/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.configuration.git;

import com.xebialabs.deployit.plugin.stitch.configuration.git.EnvironmentIndependentSshSessionFactory;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitAuthenticationStrategy;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.StringUtil$;
import java.io.File;
import java.util.regex.Matcher;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.util.matching.Regex;

public final class SshAuthenticationStrategy$
implements GitAuthenticationStrategy {
    public static final SshAuthenticationStrategy$ MODULE$ = new SshAuthenticationStrategy$();
    private static final Regex sshUrlRegex;
    private static final Regex fullUrlRegex;
    private static final Regex scpUrlRegex;

    static {
        GitAuthenticationStrategy.$init$(MODULE$);
        sshUrlRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^((ssh)|([\\w._\\-]+@[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]))(:(//)?)([\\w.@:/\\-~]+)(\\.git)?(/)?$"));
        fullUrlRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(ssh://)(?:(?:([^/:]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))(?::(\\d*))?((?:/~(?:[^\\\\/]+))?(?:[\\\\/])|$))?(.+)?$"));
        scpUrlRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?:([^/:]+)(?::([^\\\\/]+))?@)?([^\\\\/:]{2,}):([\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$"));
    }

    @Override
    public CloneCommand cloneRepoWithAuthentication(GitSource source, File configRoot) {
        return GitAuthenticationStrategy.cloneRepoWithAuthentication$(this, source, configRoot);
    }

    @Override
    public void pushWithAuthentication(Git git, GitSource gitSource, File configRoot, List<RefSpec> refSpecs) {
        GitAuthenticationStrategy.pushWithAuthentication$(this, git, gitSource, configRoot, refSpecs);
    }

    public Regex sshUrlRegex() {
        return sshUrlRegex;
    }

    public Regex fullUrlRegex() {
        return fullUrlRegex;
    }

    public Regex scpUrlRegex() {
        return scpUrlRegex;
    }

    @Override
    public boolean matches(GitUserCredentials credentials, String url) {
        return this.usernameAndPasswordSsh(credentials, url) || this.privateKeySsh(credentials, url);
    }

    private boolean usernameAndPasswordSsh(GitUserCredentials credentials, String url) {
        return this.hasUsernameAndPassword(credentials, url) && this.sshUrlRegex().pattern().matcher(url).matches();
    }

    @Override
    public boolean hasUsernameAndPassword(GitUserCredentials credentials, String url) {
        return this.hasUsername(credentials, url) && StringUtil$.MODULE$.isNotNil(credentials.password());
    }

    private boolean hasUsername(GitUserCredentials credentials, String url) {
        return this.scpUrlHasUser(url) || this.fullUrlHasUser(url) || StringUtil$.MODULE$.isNotNil(credentials.username());
    }

    private boolean privateKeySsh(GitUserCredentials credentials, String url) {
        return this.sshUrlRegex().pattern().matcher(url).matches() && StringUtil$.MODULE$.isNotNil(credentials.privateKey());
    }

    @Override
    public CloneCommand cloneRepoWithAuthentication(GitUserCredentials credentials, GitSource source, File configRoot) {
        return ((CloneCommand)Git.cloneRepository().setTransportConfigCallback(x0$1 -> {
            Transport transport = x0$1;
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new EnvironmentIndependentSshSessionFactory(credentials, configRoot));
                return;
            }
            throw new MatchError((Object)transport);
        })).setURI(this.getSshUri(credentials, source.repositoryUrl()));
    }

    private String getSshUri(GitUserCredentials credentials, String repositoryUrl) {
        Matcher urlMatcher = this.fullUrlRegex().pattern().matcher(repositoryUrl);
        Matcher scpMatcher = this.scpUrlRegex().pattern().matcher(repositoryUrl);
        if (this.fullUrlRegex().pattern().matcher(repositoryUrl).matches()) {
            return this.populateFullUrlWithUser(urlMatcher, credentials, repositoryUrl);
        }
        if (this.scpUrlRegex().pattern().matcher(repositoryUrl).matches()) {
            return this.populateScpUrlWithUser(scpMatcher, credentials, repositoryUrl);
        }
        return repositoryUrl;
    }

    private String populateFullUrlWithUser(Matcher matcher, GitUserCredentials credentials, String repositoryUrl) {
        if (!this.fullUrlHasUser(matcher) && StringUtil$.MODULE$.isNotNil(credentials.username())) {
            int usernameIndex = matcher.end(1);
            return StringOps$.MODULE$.patch$extension(Predef$.MODULE$.augmentString(repositoryUrl), usernameIndex, credentials.username() + "@", 0);
        }
        return repositoryUrl;
    }

    private String populateScpUrlWithUser(Matcher matcher, GitUserCredentials credentials, String repositoryUrl) {
        if (!this.scpUrlHasUser(matcher) && StringUtil$.MODULE$.isNotNil(credentials.username())) {
            return credentials.username() + "@" + repositoryUrl;
        }
        return repositoryUrl;
    }

    private boolean fullUrlHasUser(Matcher matcher) {
        return matcher.matches() && StringUtil$.MODULE$.isNotNil(matcher.group(2));
    }

    private boolean fullUrlHasUser(String url) {
        return this.fullUrlHasUser(this.fullUrlRegex().pattern().matcher(url));
    }

    private boolean scpUrlHasUser(Matcher matcher) {
        return matcher.matches() && StringUtil$.MODULE$.isNotNil(matcher.group(1));
    }

    private boolean scpUrlHasUser(String url) {
        return this.scpUrlHasUser(this.scpUrlRegex().pattern().matcher(url));
    }

    @Override
    public void pushWithAuthentication(Git git, GitUserCredentials credentials, File configRoot, List<RefSpec> refSpecs) {
        ((PushCommand)git.push().setRefSpecs(CollectionConverters$.MODULE$.SeqHasAsJava(refSpecs).asJava()).setTransportConfigCallback(x0$1 -> {
            Transport transport = x0$1;
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new EnvironmentIndependentSshSessionFactory(credentials, configRoot));
                return;
            }
            throw new MatchError((Object)transport);
        })).call();
    }

    @Override
    public LsRemoteCommand listWithAuthentication(GitUserCredentials credentials, String repositoryUrl, File configRoot) {
        return ((LsRemoteCommand)Git.lsRemoteRepository().setTransportConfigCallback(x0$1 -> {
            Transport transport = x0$1;
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new EnvironmentIndependentSshSessionFactory(credentials, configRoot));
                return;
            }
            throw new MatchError((Object)transport);
        })).setRemote(this.getSshUri(credentials, repositoryUrl));
    }

    private SshAuthenticationStrategy$() {
    }
}

