/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.coding;

import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.coding.DeflateCompressor;
import org.apache.pekko.http.scaladsl.coding.GzipCompressor$;
import org.apache.pekko.http.scaladsl.coding.GzipDecompressor$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a!\u0002\r\u001a\u0001e)\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000bI\u0002A\u0011A\u001a\t\u0011Y\u0002\u0001R1A\u0005R]BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0011\u001di\u0005\u00011A\u0005\n9Ca\u0001\u0016\u0001!B\u0013Q\u0005bB+\u0001\u0001\u0004%IA\u0016\u0005\b5\u0002\u0001\r\u0011\"\u0003\\\u0011\u0019i\u0006\u0001)Q\u0005/\")!\u0007\u0001C\u0001=\")q\f\u0001C)A\")\u0001\u000f\u0001C)c\")1\u000f\u0001C)i\")a\u000f\u0001C\u0005o\")\u0011\u0010\u0001C\u0005u\")1\u0010\u0001C\u0005u\u001eA\u0011qA\r\t\u0002e\tIAB\u0004\u00193!\u0005\u0011$a\u0003\t\rI\"B\u0011AA\n\u0011%\t)\u0002\u0006b\u0001\n\u0003\t9\u0002C\u0004\u0002\u001aQ\u0001\u000b\u0011\u0002\u0017\u0003\u001d\u001dS\u0018\u000e]\"p[B\u0014Xm]:pe*\u0011!dG\u0001\u0007G>$\u0017N\\4\u000b\u0005qi\u0012\u0001C:dC2\fGm\u001d7\u000b\u0005yy\u0012\u0001\u00025uiBT!\u0001I\u0011\u0002\u000bA,7n[8\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\n\u0003\u0001\u0019\u0002\"a\n\u0015\u000e\u0003eI!!K\r\u0003#\u0011+g\r\\1uK\u000e{W\u000e\u001d:fgN|'/\u0001\td_6\u0004(/Z:tS>tG*\u001a<fY\u000e\u0001\u0001CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#aA%oi\u00061A(\u001b8jiz\"\"\u0001N\u001b\u0011\u0005\u001d\u0002\u0001\"\u0002\u0016\u0003\u0001\u0004a\u0013\u0001\u00033fM2\fG/\u001a:\u0016\u0003a\u0002\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\u0007iL\u0007O\u0003\u0002>}\u0005!Q\u000f^5m\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001e\u0003\u0011\u0011+g\r\\1uKJ\f\u0001b\u00195fG.\u001cV/\\\u000b\u0002\tB\u0011\u0011(R\u0005\u0003\rj\u0012Qa\u0011*DgI\n\u0011b\u00195fG.\u001cV/\u001c\u0011\u0002\u0015!,\u0017\rZ3s'\u0016tG/F\u0001K!\ti3*\u0003\u0002M]\t9!i\\8mK\u0006t\u0017A\u00045fC\u0012,'oU3oi~#S-\u001d\u000b\u0003\u001fJ\u0003\"!\f)\n\u0005Es#\u0001B+oSRDqaU\u0004\u0002\u0002\u0003\u0007!*A\u0002yIE\n1\u0002[3bI\u0016\u00148+\u001a8uA\u0005I!-\u001f;fgJ+\u0017\rZ\u000b\u0002/B\u0011Q\u0006W\u0005\u00033:\u0012A\u0001T8oO\u0006i!-\u001f;fgJ+\u0017\rZ0%KF$\"a\u0014/\t\u000fMS\u0011\u0011!a\u0001/\u0006Q!-\u001f;fgJ+\u0017\r\u001a\u0011\u0015\u0003Q\n!cY8naJ,7o],ji\"\u0014UO\u001a4feR\u0019\u0011M\u001a5\u0011\u0005\t$W\"A2\u000b\u0005uz\u0012BA3d\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\u0006O6\u0001\r!Y\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0006S6\u0001\rA[\u0001\u0007EV4g-\u001a:\u0011\u00075ZW.\u0003\u0002m]\t)\u0011I\u001d:bsB\u0011QF\\\u0005\u0003_:\u0012AAQ=uK\u0006ya\r\\;tQ^KG\u000f\u001b\"vM\u001a,'\u000f\u0006\u0002be\")\u0011N\u0004a\u0001U\u0006\u0001b-\u001b8jg\"<\u0016\u000e\u001e5Ck\u001a4WM\u001d\u000b\u0003CVDQ![\bA\u0002)\f\u0011\"\u001e9eCR,7I]2\u0015\u0005=C\b\"B4\u0011\u0001\u0004\t\u0017A\u00025fC\u0012,'\u000fF\u0001b\u0003\u001d!(/Y5mKJD#\u0001A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taH\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0003\u007f\nY\u0011J\u001c;fe:\fG.\u00119j\u000399%0\u001b9D_6\u0004(/Z:t_J\u0004\"a\n\u000b\u0014\u0007Q\ti\u0001E\u0002.\u0003\u001fI1!!\u0005/\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011B\u0001\u0018\t\u00164\u0017-\u001e7u\u0007>l\u0007O]3tg&|g\u000eT3wK2,\u0012\u0001L\u0001\u0019\t\u00164\u0017-\u001e7u\u0007>l\u0007O]3tg&|g\u000eT3wK2\u0004\u0003F\u0001\u000b~Q\t\u0019R\u0010")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final int compressionLevel;
    private final CRC32 checkSum;
    private boolean headerSent;
    private long bytesRead;
    private volatile boolean bitmap$0;

    public static int DefaultCompressionLevel() {
        return GzipCompressor$.MODULE$.DefaultCompressionLevel();
    }

    private Deflater deflater$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(this.compressionLevel, true);
                this.bitmap$0 = true;
            }
        }
        return this.deflater;
    }

    @Override
    public Deflater deflater() {
        if (!this.bitmap$0) {
            return this.deflater$lzycompute();
        }
        return this.deflater;
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update(input.toArrayUnsafe());
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        if (!this.headerSent()) {
            this.headerSent_$eq(true);
            return GzipDecompressor$.MODULE$.Header();
        }
        return ByteString$.MODULE$.empty();
    }

    private ByteString trailer() {
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        return GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public GzipCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        super(compressionLevel);
        this.checkSum = new CRC32();
        this.headerSent = false;
        this.bytesRead = 0L;
    }

    public GzipCompressor() {
        this(GzipCompressor$.MODULE$.DefaultCompressionLevel());
    }
}

