/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAQueueConnectionFactory;
import jakarta.jms.XATopicConnectionFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQTopicConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAQueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXATopicConnectionFactory;

public enum JMSFactoryType {
    CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQJMSConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQJMSConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQJMSConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQJMSConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return ConnectionFactory.class;
        }
    }
    ,
    QUEUE_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQQueueConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQQueueConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQQueueConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQQueueConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return QueueConnectionFactory.class;
        }
    }
    ,
    TOPIC_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQTopicConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQTopicConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQTopicConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQTopicConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return TopicConnectionFactory.class;
        }
    }
    ,
    XA_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQXAConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQXAConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return XAConnectionFactory.class;
        }
    }
    ,
    QUEUE_XA_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAQueueConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAQueueConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQXAQueueConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQXAQueueConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return XAQueueConnectionFactory.class;
        }
    }
    ,
    TOPIC_XA_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXATopicConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXATopicConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQXATopicConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQXATopicConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return XATopicConnectionFactory.class;
        }
    };


    public int intValue() {
        int val = 0;
        switch (this) {
            case CF: {
                val = 0;
                break;
            }
            case QUEUE_CF: {
                val = 1;
                break;
            }
            case TOPIC_CF: {
                val = 2;
                break;
            }
            case XA_CF: {
                val = 3;
                break;
            }
            case QUEUE_XA_CF: {
                val = 4;
                break;
            }
            case TOPIC_XA_CF: {
                val = 5;
            }
        }
        return val;
    }

    public static JMSFactoryType valueOf(int val) {
        JMSFactoryType type;
        switch (val) {
            case 0: {
                type = CF;
                break;
            }
            case 1: {
                type = QUEUE_CF;
                break;
            }
            case 2: {
                type = TOPIC_CF;
                break;
            }
            case 3: {
                type = XA_CF;
                break;
            }
            case 4: {
                type = QUEUE_XA_CF;
                break;
            }
            case 5: {
                type = TOPIC_XA_CF;
                break;
            }
            default: {
                type = XA_CF;
            }
        }
        return type;
    }

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration var1);

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration var1);

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... var1);

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... var1);

    public abstract Class connectionFactoryInterface();
}

