/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DelegatingReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final List<ReactiveAuthenticationManager> delegates;
    private boolean continueOnError = false;
    private final Log logger = LogFactory.getLog(this.getClass());

    public DelegatingReactiveAuthenticationManager(ReactiveAuthenticationManager ... entryPoints) {
        this(Arrays.asList(entryPoints));
    }

    public DelegatingReactiveAuthenticationManager(List<ReactiveAuthenticationManager> entryPoints) {
        Assert.notEmpty(entryPoints, (String)"entryPoints cannot be null");
        this.delegates = entryPoints;
    }

    @Override
    public Mono<Authentication> authenticate(Authentication authentication) {
        Flux result = Flux.fromIterable(this.delegates);
        Function<ReactiveAuthenticationManager, Mono> logging = m -> m.authenticate(authentication).doOnError(arg_0 -> ((Log)this.logger).debug(arg_0));
        return (this.continueOnError ? result.concatMapDelayError(logging) : result.concatMap(logging)).next();
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }
}

