/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.Verification;
import com.xebialabs.deployit.plugin.api.reflect.Verify;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.javadude.scannit.Scannit;

public class VerificationConverter {
    private static final Map<String, Class<? extends Verification>> verificationTypeMap = new HashMap<String, Class<? extends Verification>>();

    private VerificationConverter() {
    }

    public static void initialize() {
        verificationTypeMap.clear();
        Set rules = Scannit.getInstance().getTypesAnnotatedWith(Verify.class);
        for (Class validationRuleAnnotation : rules) {
            Verify verify = validationRuleAnnotation.getAnnotation(Verify.class);
            verificationTypeMap.put(verify.type(), verify.clazz());
        }
    }

    static boolean isVerification(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Verify.class);
    }

    static <T extends Verification> T makeVerification(Annotation verificationAnnotation) {
        Class<? extends Annotation> verificationClazz = verificationAnnotation.annotationType();
        Verify verify = verificationClazz.getAnnotation(Verify.class);
        return (T)VerificationConverter.instantiate(verify.clazz());
    }

    public static <T extends Verification> T makeVerification(String type, Type ciType) {
        Verification rule = VerificationConverter.createRule(type);
        if (rule != null) {
            return (T)rule;
        }
        throw new IllegalArgumentException(String.format("Could not find verification type %s defined on type %s", type, ciType));
    }

    private static Verification createRule(String type) {
        if (verificationTypeMap.containsKey(type)) {
            return VerificationConverter.instantiate(verificationTypeMap.get(type));
        }
        return null;
    }

    private static Verification instantiate(Class<? extends Verification> rule) {
        try {
            return rule.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + String.valueOf(rule), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + String.valueOf(rule), e);
        }
    }

    static {
        VerificationConverter.initialize();
    }
}

