/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;

public class SizeFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean acceptLarger;
    private final long size;

    public SizeFileFilter(long size) {
        this(size, true);
    }

    public SizeFileFilter(long size, boolean acceptLarger) {
        if (size < 0L) {
            throw new IllegalArgumentException("The size must be non-negative");
        }
        this.size = size;
        this.acceptLarger = acceptLarger;
    }

    @Override
    public boolean accept(FileSelectInfo fileSelectInfo) throws FileSystemException {
        try (FileObject file = fileSelectInfo.getFile();){
            boolean bl;
            block14: {
                if (!file.exists()) {
                    boolean bl2 = false;
                    return bl2;
                }
                FileContent content = file.getContent();
                try {
                    long length = content.getSize();
                    boolean smaller = length < this.size;
                    boolean bl3 = bl = this.acceptLarger != smaller;
                    if (content == null) break block14;
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                content.close();
            }
            return bl;
        }
    }

    public String toString() {
        String condition = this.acceptLarger ? ">=" : "<";
        return super.toString() + "(" + condition + this.size + ")";
    }
}

