/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.startup;

import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.exception.PluginsVerificationException;
import com.xebialabs.plugin.manager.metadata.XLProduct;
import com.xebialabs.plugin.manager.metadata.XLProduct$;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.model.DbPlugin$;
import com.xebialabs.plugin.manager.model.DbPlugin$DbPluginOps$;
import com.xebialabs.plugin.manager.model.FilePlugin;
import com.xebialabs.plugin.manager.model.FilePlugin$;
import com.xebialabs.plugin.manager.model.FilePlugin$FilePluginOps$;
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.startup.SourceOfTruth$;
import com.xebialabs.plugin.manager.util.PluginsTraverser$;
import com.xebialabs.xlplatform.sugar.PathSugar$;
import de.schlichtherle.truezip.file.TFile;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015Y\u0006\u0001\"\u0001c\u0011\u001d1\u0007A1A\u0005\u0002\u001dDaA\u001c\u0001!\u0002\u0013A\u0007\"B8\u0001\t\u0003\u0001\b\"\u0002;\u0001\t\u0003\u0001\b\"\u0002;\u0001\t\u0013)\bbBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u0019y\u0007\u0001\"\u0003\u0002.!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|\t\u0011\u0002\u000b\\;hS:\u001c\u0016P\\2ie>t\u0017N_3s\u0015\tA\u0012$A\u0004ti\u0006\u0014H/\u001e9\u000b\u0005iY\u0012aB7b]\u0006<WM\u001d\u0006\u00039u\ta\u0001\u001d7vO&t'B\u0001\u0010 \u0003%AXMY5bY\u0006\u00147OC\u0001!\u0003\r\u0019w.\\\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013!B:mMRR'\"\u0001\u0018\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001M\u0016\u0003\u000f1{wmZ5oO\u0006\u0001\u0002\u000f\\;hS:\u0014V\r]8tSR|'/\u001f\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n1a]9m\u0015\t9\u0014$\u0001\u0006sKB|7/\u001b;pefL!!\u000f\u001b\u0003'M\u000bH\u000e\u00157vO&t'+\u001a9pg&$xN]=\u0002\u000fA\u0014x\u000eZ;diB\u0011Ah\u0011\b\u0003{\u0005\u0003\"AP\u0013\u000e\u0003}R!\u0001Q\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\u0011U%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"&\u0003)\u0001H.^4j]N$\u0015N\u001d\t\u0003\u0011>k\u0011!\u0013\u0006\u0003\u0015.\u000bAAZ5mK*\u0011A*T\u0001\u0004]&|'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!&\u0013A\u0001U1uQ\u0006i1o\\;sG\u0016|e\r\u0016:vi\"\u0004\"aU,\u000f\u0005Q+V\"A\f\n\u0005Y;\u0012!D*pkJ\u001cWm\u00144UeV$\b.\u0003\u0002Y3\n)a+\u00197vK&\u0011!,\n\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0006;z{\u0006-\u0019\t\u0003)\u0002AQ!M\u0003A\u0002IBQAO\u0003A\u0002mBQAR\u0003A\u0002\u001dCQ!U\u0003A\u0002I#B!X2eK\")\u0011G\u0002a\u0001e!)!H\u0002a\u0001w!)\u0011K\u0002a\u0001%\u0006I\u0001\u0010\u001c)s_\u0012,8\r^\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.G\u0001\t[\u0016$\u0018\rZ1uC&\u0011QN\u001b\u0002\n12\u0003&o\u001c3vGR\f!\u0002\u001f7Qe>$Wo\u0019;!\u0003-\u0019\u0018P\\2QYV<\u0017N\\:\u0015\u0003E\u0004\"\u0001\n:\n\u0005M,#\u0001B+oSR\fQB^3sS\u001aL\b\u000b\\;hS:\u001cH\u0003B9w\u0003\u001fAQa^\u0006A\u0002a\f\u0011BZ:QYV<\u0017N\\:\u0011\tet\u00181\u0001\b\u0003urt!AP>\n\u0003\u0019J!!`\u0013\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\t1K7\u000f\u001e\u0006\u0003{\u0016\u0002B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013I\u0012!B7pI\u0016d\u0017\u0002BA\u0007\u0003\u000f\u0011!BR5mKBcWoZ5o\u0011\u001d\t\tb\u0003a\u0001\u0003'\t\u0011\u0002\u001a2QYV<\u0017N\\:\u0011\u000be\f)\"!\u0007\n\t\u0005]\u0011\u0011\u0001\u0002\u0004'\u0016\f\b\u0003BA\u0003\u00037IA!!\b\u0002\b\tAAI\u0019)mk\u001eLg.\u0001\rwKJLg-\u001f$t\u001b\u0006$8\r[3t\t\n\u0004F.^4j]N$R!]A\u0012\u0003KAQa\u001e\u0007A\u0002aDq!!\u0005\r\u0001\u0004\t\u0019\"A\rwKJLg-_!mYBcWoZ5og&s7\u000f^1mY\u0016$GcA9\u0002,!9\u0011\u0011C\u0007A\u0002\u0005MAcB9\u00020\u0005E\u00121\u0007\u0005\u0006o:\u0001\r\u0001\u001f\u0005\b\u0003#q\u0001\u0019AA\n\u0011\u001d\t)D\u0004a\u0001\u0003o\tA\u0002\u001d7vO&t7k\\;sG\u0016\u00042!!\u000fX\u001d\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n1!\u00199j\u0015\r\t\u0019%G\u0001\u0005e\u0016\u001cH/\u0003\u0003\u0002H\u0005u\u0012\u0001\u0004)mk\u001eLgnU8ve\u000e,\u0017AG:z]\u000e,6/\u001b8h\t\n\f5oU8ve\u000e,wJ\u001a+skRDG#B9\u0002N\u0005=\u0003\"B<\u0010\u0001\u0004A\bbBA\t\u001f\u0001\u0007\u00111C\u0001\u001bgft7-V:j]\u001e45/Q:T_V\u00148-Z(g)J,H\u000f\u001b\u000b\bc\u0006U\u0013qKA-\u0011\u00159\b\u00031\u0001y\u0011\u001d\t\t\u0002\u0005a\u0001\u0003'Aq!!\u000e\u0011\u0001\u0004\t9$A\txe&$X\rV8GS2,7/_:uK6$2!]A0\u0011\u001d\t\t'\u0005a\u0001\u00033\t\u0001\u0002\u001a2QYV<\u0017N\\\u0001\u0016G2,\u0017M\\;q\rJ|WNR5mKNL8\u000f^3n)\r\t\u0018q\r\u0005\b\u0003S\u0012\u0002\u0019AA\u0002\u0003!17\u000f\u00157vO&t\u0017aE2mK\u0006tW\u000f\u001d$s_6$\u0015\r^1cCN,GcA9\u0002p!9\u0011\u0011M\nA\u0002\u0005e\u0011aD<sSR,Gk\u001c#bi\u0006\u0014\u0017m]3\u0015\u000bE\f)(a\u001e\t\rq!\u0002\u0019AA\u0002\u0011\u001d\t)\u0004\u0006a\u0001\u0003o\tA#\u001b8jiB\u0013x\u000eZ;diN\u0003XmY5gS\u000e\u001cHcA9\u0002~!)!(\u0006a\u0001Q\u0002")
public class PluginSynchronizer
implements Logging {
    private final SqlPluginRepository pluginRepository;
    private final Path pluginsDir;
    private final Enumeration.Value sourceOfTruth;
    private final XLProduct xlProduct;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginSynchronizer pluginSynchronizer = this;
        synchronized (pluginSynchronizer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XLProduct xlProduct() {
        return this.xlProduct;
    }

    public void syncPlugins() {
        if (PathSugar$.MODULE$.path2File(this.pluginsDir).exists() && this.pluginRepository.pluginTablesExist()) {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Starting plugin synchronization, using " + $this.sourceOfTruth + " as source of truth");
            Map dbPluginsBySource = this.pluginRepository.getAllWithBytes().groupBy((Function1 & Serializable)x$1 -> x$1.source().toString());
            PluginsTraverser$.MODULE$.traverse(this.pluginsDir, (Function2<Enumeration.Value, List<FilePlugin>, BoxedUnit>)(Function2 & Serializable)(pluginSource, plugins) -> {
                this.syncPlugins((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)pluginSource.toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())), pluginSource);
                return BoxedUnit.UNIT;
            }, (Function1<List<FilePlugin>, BoxedUnit>)(Function1 & Serializable)plugins -> {
                this.syncPlugins((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)PluginSource$.MODULE$.LOCAL().toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())), PluginSource$.MODULE$.LOCAL());
                return BoxedUnit.UNIT;
            });
            this.pluginRepository.updateAllPluginsStatusTo(PluginStatus$.MODULE$.INSTALLED());
            return;
        }
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Skipping plugin synchronization, database is not ready yet.");
    }

    public void verifyPlugins() {
        if (PathSugar$.MODULE$.path2File(this.pluginsDir).exists() && this.pluginRepository.pluginTablesExist()) {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Starting plugin verification, using " + $this.sourceOfTruth + " as source of truth");
            Map dbPluginsBySource = this.pluginRepository.getAllWithBytes().groupBy((Function1 & Serializable)x$2 -> x$2.source().toString());
            PluginsTraverser$.MODULE$.traverse(this.pluginsDir, (Function2<Enumeration.Value, List<FilePlugin>, BoxedUnit>)(Function2 & Serializable)(pluginSource, plugins) -> {
                this.verifyPlugins((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)pluginSource.toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())));
                return BoxedUnit.UNIT;
            }, (Function1<List<FilePlugin>, BoxedUnit>)(Function1 & Serializable)plugins -> {
                this.verifyPlugins((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)PluginSource$.MODULE$.LOCAL().toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void verifyPlugins(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        Enumeration.Value value = this.sourceOfTruth;
        Enumeration.Value value2 = SourceOfTruth$.MODULE$.FILE_SYSTEM();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.verifyFsMatchesDbPlugins(fsPlugins, dbPlugins);
            return;
        }
        Enumeration.Value value4 = SourceOfTruth$.MODULE$.DATABASE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.verifyAllPluginsInstalled(dbPlugins);
            this.syncUsingDbAsSourceOfTruth(fsPlugins, dbPlugins);
            return;
        }
        throw new MatchError((Object)value);
    }

    private void verifyFsMatchesDbPlugins(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        Map dbPluginsMap = ((IterableOnceOps)dbPlugins.map((Function1 & Serializable)dbPlugin -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dbPlugin.name()), dbPlugin))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean allPluginsMatches = fsPlugins.forall((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginSynchronizer.$anonfun$verifyFsMatchesDbPlugins$2(dbPluginsMap, fsPlugin)));
        if (!allPluginsMatches) {
            throw new PluginsVerificationException("Mismatched plugins found during verification, please run synchronization.");
        }
    }

    private void verifyAllPluginsInstalled(Seq<DbPlugin> dbPlugins) {
        boolean allInstalled = dbPlugins.forall((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginSynchronizer.$anonfun$verifyAllPluginsInstalled$1(dbPlugin)));
        if (!allInstalled) {
            throw new PluginsVerificationException("Plugins ready for install found during verification, please run synchronization.");
        }
    }

    private void syncPlugins(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins, Enumeration.Value pluginSource) {
        Enumeration.Value value = this.sourceOfTruth;
        Enumeration.Value value2 = SourceOfTruth$.MODULE$.FILE_SYSTEM();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.syncUsingFsAsSourceOfTruth(fsPlugins, dbPlugins, pluginSource);
            return;
        }
        Enumeration.Value value4 = SourceOfTruth$.MODULE$.DATABASE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.syncUsingDbAsSourceOfTruth(fsPlugins, dbPlugins);
            return;
        }
        throw new MatchError((Object)value);
    }

    private void syncUsingDbAsSourceOfTruth(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.cleanupFromFilesystem(fsPlugin);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.writeToFilesystem(dbPlugin);
            return BoxedUnit.UNIT;
        });
        Seq mismatchedDbPlugins = (Seq)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.hasDifferentContentOrVersionThanANameMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)));
        List mismatchedFsPlugins = fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.hasDifferentContentAndVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins)));
        mismatchedFsPlugins.foreach((Function1 & Serializable)fsPlugin -> {
            this.cleanupFromFilesystem(fsPlugin);
            return BoxedUnit.UNIT;
        });
        mismatchedDbPlugins.foreach((Function1 & Serializable)dbPlugin -> {
            this.writeToFilesystem(dbPlugin);
            return BoxedUnit.UNIT;
        });
    }

    private void syncUsingFsAsSourceOfTruth(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins, Enumeration.Value pluginSource) {
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.cleanupFromDatabase(dbPlugin);
            return BoxedUnit.UNIT;
        });
        fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.writeToDatabase(fsPlugin, pluginSource);
            return BoxedUnit.UNIT;
        });
        Seq mismatchedDbPlugins = (Seq)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.hasDifferentContentOrVersionThanANameMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins)));
        List mismatchedFsPlugins = fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.hasDifferentContentAndVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins)));
        mismatchedDbPlugins.foreach((Function1 & Serializable)dbPlugin -> {
            this.cleanupFromDatabase(dbPlugin);
            return BoxedUnit.UNIT;
        });
        mismatchedFsPlugins.foreach((Function1 & Serializable)fsPlugin -> {
            this.writeToDatabase(fsPlugin, pluginSource);
            return BoxedUnit.UNIT;
        });
    }

    private void writeToFilesystem(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Copying plugin " + dbPlugin.name() + " from database to filesystem");
        String fileName = dbPlugin.name() + (dbPlugin.version().isEmpty() ? "" : "-" + dbPlugin.version().get()) + "." + dbPlugin.extension();
        File targetFile = new File(this.pluginsDir + File.separator + dbPlugin.source() + File.separator + fileName);
        FileUtils.writeByteArrayToFile((File)targetFile, (byte[])((byte[])dbPlugin.bytes().get()));
    }

    private void cleanupFromFilesystem(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Removing plugin " + fsPlugin.name() + " from filesystem");
        TFiles.umountQuietly((TFile)new TFile(PathSugar$.MODULE$.path2File(fsPlugin.filePath())));
        FileUtils.forceDelete((File)PathSugar$.MODULE$.path2File(fsPlugin.filePath()));
    }

    private void cleanupFromDatabase(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Removing plugin " + dbPlugin.name() + " from database");
        this.pluginRepository.delete(dbPlugin);
    }

    private void writeToDatabase(FilePlugin plugin, Enumeration.Value pluginSource) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Inserting plugin " + plugin.name() + " into database");
        Enumeration.Value value = pluginSource;
        Enumeration.Value value2 = PluginSource$.MODULE$.LOCAL();
        Enumeration.Value value3 = value;
        DbPlugin dbPlugin = !(value2 != null ? !value2.equals(value3) : value3 != null) ? FilePlugin$FilePluginOps$.MODULE$.toLocalDbPlugin$extension(FilePlugin$.MODULE$.FilePluginOps(plugin)) : FilePlugin$FilePluginOps$.MODULE$.toOfficialDbPlugin$extension(FilePlugin$.MODULE$.FilePluginOps(plugin), this.xlProduct());
        this.pluginRepository.insert(dbPlugin);
    }

    private void initProductSpecifics(XLProduct product) {
        ConfigWrapper$.MODULE$.initWith(product);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFsMatchesDbPlugins$2(Map dbPluginsMap$1, FilePlugin fsPlugin) {
        return dbPluginsMap$1.contains((Object)fsPlugin.name()) && FilePlugin$FilePluginOps$.MODULE$.matches$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (DbPlugin)dbPluginsMap$1.apply((Object)fsPlugin.name()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyAllPluginsInstalled$1(DbPlugin dbPlugin) {
        Enumeration.Value value = dbPlugin.installationStatus();
        Enumeration.Value value2 = PluginStatus$.MODULE$.INSTALLED();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public PluginSynchronizer(SqlPluginRepository pluginRepository, String product, Path pluginsDir, Enumeration.Value sourceOfTruth) {
        this.pluginRepository = pluginRepository;
        this.pluginsDir = pluginsDir;
        this.sourceOfTruth = sourceOfTruth;
        Logging.$init$((Logging)this);
        this.xlProduct = XLProduct$.MODULE$.fromString(product);
        this.initProductSpecifics(this.xlProduct());
    }

    public PluginSynchronizer(SqlPluginRepository pluginRepository, String product, Enumeration.Value sourceOfTruth) {
        this(pluginRepository, product, Paths.get("plugins", new String[0]), sourceOfTruth);
    }
}

