/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.config.server.environment.AbstractScmEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;

public class SvnKitEnvironmentRepository
extends AbstractScmEnvironmentRepository
implements EnvironmentRepository,
InitializingBean {
    private static Log logger = LogFactory.getLog(SvnKitEnvironmentRepository.class);
    private String defaultLabel;

    public SvnKitEnvironmentRepository(ConfigurableEnvironment environment, SvnKitEnvironmentProperties properties, ObservationRegistry observationRegistry) {
        super(environment, properties, observationRegistry);
        this.defaultLabel = properties.getDefaultLabel();
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public synchronized SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        if (label == null) {
            label = this.defaultLabel;
        }
        SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
        if (StringUtils.hasText((String)this.getUsername())) {
            svnOperationFactory.setAuthenticationManager((ISVNAuthenticationManager)new DefaultSVNAuthenticationManager(null, false, this.getUsername(), this.getPassword()));
        }
        try {
            String version = new File(this.getWorkingDirectory(), ".svn").exists() ? this.update(svnOperationFactory, label) : this.checkout(svnOperationFactory);
            SearchPathLocator.Locations locations = new SearchPathLocator.Locations(application, profile, label, version, this.getPaths(application, profile, label));
            return locations;
        }
        catch (SVNException e) {
            throw new IllegalStateException("Cannot checkout repository", e);
        }
        finally {
            svnOperationFactory.dispose();
        }
    }

    private String[] getPaths(String application, String profile, String label) {
        String[] locations = this.getSearchLocations(this.getSvnPath(this.getWorkingDirectory(), label), application, profile, label);
        boolean exists = false;
        for (String location : locations) {
            URI locationUri = URI.create(location = StringUtils.cleanPath((String)location));
            if (!new File(locationUri).exists()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            throw new NoSuchLabelException("No label found for: " + label);
        }
        return locations;
    }

    private String checkout(SvnOperationFactory svnOperationFactory) throws SVNException {
        logger.debug((Object)("Checking out " + this.getUri() + " to: " + this.getWorkingDirectory().getAbsolutePath()));
        SvnCheckout checkout = svnOperationFactory.createCheckout();
        checkout.setSource(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)this.getUri())));
        checkout.setSingleTarget(SvnTarget.fromFile((File)this.getWorkingDirectory()));
        Long id = (Long)checkout.run();
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    private String update(SvnOperationFactory svnOperationFactory, String label) throws SVNException {
        logger.debug((Object)"Repo already checked out - updating instead.");
        try {
            SvnUpdate update = svnOperationFactory.createUpdate();
            update.setSingleTarget(SvnTarget.fromFile((File)this.getWorkingDirectory()));
            long[] ids = (long[])update.run();
            StringBuilder version = new StringBuilder();
            for (long id : ids) {
                if (version.length() > 0) {
                    version.append(",");
                }
                version.append(id);
            }
            return version.toString();
        }
        catch (Exception e) {
            String message = "Could not update remote for " + label + " (current local=" + this.getWorkingDirectory().getPath() + "), remote: " + this.getUri() + ")";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)message, (Throwable)e);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)message);
            }
            SVNStatus status = SVNClientManager.newInstance().getStatusClient().doStatus(this.getWorkingDirectory(), false);
            return status != null ? status.getRevision().toString() : null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.getUri() != null ? 1 : 0) != 0, (String)"You need to configure a uri for the subversion repository (e.g. 'https://example.com/svn/')");
        this.resolveRelativeFileUri();
    }

    private void resolveRelativeFileUri() {
        if (this.getUri().startsWith("file:///./")) {
            String path = this.getUri().substring(8);
            String absolutePath = new File(path).getAbsolutePath();
            this.setUri("file:///" + StringUtils.cleanPath((String)absolutePath));
        }
    }

    @Override
    protected File getWorkingDirectory() {
        return this.getBasedir();
    }

    private File getSvnPath(File workingDirectory, String label) {
        File svnPath = new File(workingDirectory, label);
        if (!(svnPath.exists() || (svnPath = new File(workingDirectory, "branches" + File.separator + label)).exists() || (svnPath = new File(workingDirectory, "tags" + File.separator + label)).exists())) {
            throw new NoSuchLabelException("No label found for: " + label);
        }
        return svnPath;
    }

    @Override
    public void setOrder(int order) {
        super.setOrder(order);
    }
}

