/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class ClusteringConfiguration
extends ConfigurationElement<ClusteringConfiguration> {
    public static final AttributeDefinition<CacheType> CACHE_TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, (Object)((Object)CacheType.LOCAL)).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> CACHE_SYNC = AttributeDefinition.builder((Enum)Attribute.MODE, (Object)true, Boolean.class).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Long> REMOTE_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.REMOTE_TIMEOUT, (Object)TimeUnit.SECONDS.toMillis(15L)).build();
    public static final AttributeDefinition<Integer> INVALIDATION_BATCH_SIZE = AttributeDefinition.builder((Enum)Attribute.INVALIDATION_BATCH_SIZE, (Object)128).immutable().build();
    public static final AttributeDefinition<BiasAcquisition> BIAS_ACQUISITION = AttributeDefinition.builder((Enum)Attribute.BIAS_ACQUISITION, (Object)((Object)BiasAcquisition.ON_WRITE)).immutable().build();
    public static final AttributeDefinition<Long> BIAS_LIFESPAN = AttributeDefinition.builder((Enum)Attribute.BIAS_LIFESPAN, (Object)TimeUnit.MINUTES.toMillis(5L)).immutable().build();
    private final CacheMode cacheMode;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> remoteTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> invalidationBatchSize;
    private final HashConfiguration hashConfiguration;
    private final L1Configuration l1Configuration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final PartitionHandlingConfiguration partitionHandlingConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ClusteringConfiguration.class, new AttributeDefinition[]{CACHE_TYPE, CACHE_SYNC, REMOTE_TIMEOUT, INVALIDATION_BATCH_SIZE, BIAS_ACQUISITION, BIAS_LIFESPAN});
    }

    ClusteringConfiguration(AttributeSet attributes, HashConfiguration hashConfiguration, L1Configuration l1Configuration, StateTransferConfiguration stateTransferConfiguration, PartitionHandlingConfiguration partitionHandlingStrategy) {
        super((Enum)Element.CLUSTERING, attributes, new ConfigurationElement[]{hashConfiguration, l1Configuration, stateTransferConfiguration, partitionHandlingStrategy});
        this.cacheMode = CacheMode.of((CacheType)((Object)attributes.attribute(CACHE_TYPE).get()), (Boolean)attributes.attribute(CACHE_SYNC).get());
        this.remoteTimeout = attributes.attribute(REMOTE_TIMEOUT);
        this.invalidationBatchSize = attributes.attribute(INVALIDATION_BATCH_SIZE);
        this.hashConfiguration = hashConfiguration;
        this.l1Configuration = l1Configuration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.partitionHandlingConfiguration = partitionHandlingStrategy;
    }

    public CacheMode cacheMode() {
        return this.cacheMode;
    }

    public long remoteTimeout() {
        return (Long)this.remoteTimeout.get();
    }

    public void remoteTimeout(long timeoutMillis) {
        this.remoteTimeout.set((Object)timeoutMillis);
    }

    public PartitionHandlingConfiguration partitionHandling() {
        return this.partitionHandlingConfiguration;
    }

    public String cacheModeString() {
        return this.cacheMode() == null ? "none" : this.cacheMode().toString();
    }

    public int invalidationBatchSize() {
        return (Integer)this.invalidationBatchSize.get();
    }

    public BiasAcquisition biasAcquisition() {
        return (BiasAcquisition)((Object)this.attributes.attribute(BIAS_ACQUISITION).get());
    }

    public long biasLifespan() {
        return (Long)this.attributes.attribute(BIAS_LIFESPAN).get();
    }

    public HashConfiguration hash() {
        return this.hashConfiguration;
    }

    public L1Configuration l1() {
        return this.l1Configuration;
    }

    public StateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }
}

