/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class Jvm {
    private static final boolean MODULAR_JVM;

    Jvm() {
    }

    static boolean isModular() {
        return MODULAR_JVM;
    }

    static {
        Matcher matcher;
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.specification.version");
            }
        });
        boolean modularJvm = false;
        if (value != null && (matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(value)).find()) {
            modularJvm = Integer.parseInt(matcher.group(1)) >= 9;
        }
        MODULAR_JVM = modularJvm;
    }
}

