/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.MultiProcCpu;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class MultiPs
extends SigarCommandBase {
    public MultiPs(Shell shell) {
        super(shell);
    }

    public MultiPs() {
    }

    protected boolean validateArgs(String[] args) {
        return args.length == 1;
    }

    public String getSyntaxArgs() {
        return "query";
    }

    public String getUsageShort() {
        return "Show multi process status";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        String query = args[0];
        MultiProcCpu cpu = this.proxy.getMultiProcCpu(query);
        this.println("Number of processes: " + cpu.getProcesses());
        this.println("Cpu usage: " + CpuPerc.format(cpu.getPercent()));
        this.println("Cpu time: " + Ps.getCpuTime(cpu.getTotal()));
        ProcMem mem = this.proxy.getMultiProcMem(query);
        this.println("Size: " + Sigar.formatSize(mem.getSize()));
        this.println("Resident: " + Sigar.formatSize(mem.getResident()));
        this.println("Share: " + Sigar.formatSize(mem.getShare()));
    }

    public static void main(String[] args) throws Exception {
        new MultiPs().processCommand(args);
    }
}

