/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.TransactionHolder;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

class JDBCJournalReaderCallback
implements JournalReaderCallback {
    private final Map<Long, TransactionHolder> loadTransactions = new LinkedHashMap<Long, TransactionHolder>();
    private final LoaderCallback loadManager;

    JDBCJournalReaderCallback(LoaderCallback loadManager) {
        this.loadManager = loadManager;
    }

    public void onReadAddRecord(RecordInfo info) throws Exception {
        this.loadManager.addRecord(info);
    }

    public void onReadUpdateRecord(RecordInfo info) throws Exception {
        this.loadManager.updateRecord(info);
    }

    public void onReadDeleteRecord(long recordID) throws Exception {
        this.loadManager.deleteRecord(recordID);
    }

    public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
        TransactionHolder tx = this.loadTransactions.get(transactionID);
        if (tx == null) {
            tx = new TransactionHolder(transactionID);
            this.loadTransactions.put(transactionID, tx);
        }
        tx.recordInfos.add(info);
    }

    public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
        TransactionHolder tx = this.loadTransactions.get(transactionID);
        if (tx == null) {
            tx = new TransactionHolder(transactionID);
            this.loadTransactions.put(transactionID, tx);
        }
        tx.recordInfos.add(info);
    }

    public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
        TransactionHolder tx = this.loadTransactions.get(transactionID);
        if (tx == null) {
            tx = new TransactionHolder(transactionID);
            this.loadTransactions.put(transactionID, tx);
        }
        tx.recordsToDelete.add(info);
    }

    public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
        TransactionHolder tx = this.loadTransactions.get(transactionID);
        if (tx == null) {
            tx = new TransactionHolder(transactionID);
            this.loadTransactions.put(transactionID, tx);
        }
        tx.prepared = true;
        tx.extraData = extraData;
    }

    public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
        TransactionHolder tx = this.loadTransactions.get(transactionID);
        if (tx != null) {
            tx.committed = true;
            for (RecordInfo txRecord : tx.recordInfos) {
                if (txRecord.isUpdate) {
                    this.loadManager.updateRecord(txRecord);
                    continue;
                }
                this.loadManager.addRecord(txRecord);
            }
        }
    }

    public void onReadRollbackRecord(long transactionID) throws Exception {
        TransactionHolder tx = this.loadTransactions.remove(transactionID);
        if (tx == null) {
            throw new IllegalStateException("Cannot rollback, tx not found with ID: " + transactionID);
        }
    }

    public void markAsDataFile(JournalFile file) {
    }

    void checkPreparedTx() {
        for (TransactionHolder transaction : this.loadTransactions.values()) {
            if (!transaction.prepared && !transaction.committed || transaction.invalid) {
                ActiveMQJournalLogger.LOGGER.uncomittedTxFound(Long.valueOf(transaction.transactionID));
                this.loadManager.failedTransaction(transaction.transactionID, transaction.recordInfos, transaction.recordsToDelete);
                continue;
            }
            if (transaction.committed) continue;
            PreparedTransactionInfo info = new PreparedTransactionInfo(transaction.transactionID, transaction.extraData);
            info.getRecords().addAll(transaction.recordInfos);
            info.getRecordsToDelete().addAll(transaction.recordsToDelete);
            this.loadManager.addPreparedTransaction(info);
        }
    }

    public Map<Long, TransactionHolder> getTransactions() {
        return this.loadTransactions;
    }
}

