/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.observation;

import io.micrometer.observation.ObservationRegistry;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.observation.CircuitBreakerObservationContext;
import org.springframework.cloud.client.circuitbreaker.observation.CircuitBreakerObservationConvention;
import org.springframework.cloud.client.circuitbreaker.observation.ObservedFunction;
import org.springframework.cloud.client.circuitbreaker.observation.ObservedSupplier;

public class ObservedCircuitBreaker
implements CircuitBreaker {
    private final CircuitBreaker delegate;
    private final ObservationRegistry observationRegistry;
    private CircuitBreakerObservationConvention customConvention;

    public ObservedCircuitBreaker(CircuitBreaker delegate, ObservationRegistry observationRegistry) {
        this.delegate = delegate;
        this.observationRegistry = observationRegistry;
    }

    @Override
    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        return this.delegate.run(new ObservedSupplier<T>(this.customConvention, new CircuitBreakerObservationContext(CircuitBreakerObservationContext.Type.SUPPLIER), "circuit-breaker", this.observationRegistry, toRun), new ObservedFunction<T>(this.customConvention, new CircuitBreakerObservationContext(CircuitBreakerObservationContext.Type.FUNCTION), "circuit-breaker fallback", this.observationRegistry, fallback));
    }

    @Override
    public <T> T run(Supplier<T> toRun) {
        return this.delegate.run(new ObservedSupplier<T>(this.customConvention, new CircuitBreakerObservationContext(CircuitBreakerObservationContext.Type.SUPPLIER), "circuit-breaker", this.observationRegistry, toRun));
    }

    public void setCustomConvention(CircuitBreakerObservationConvention customConvention) {
        this.customConvention = customConvention;
    }
}

