/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.oidc.IdTokenClaimAccessor;
import org.springframework.util.Assert;

public class OidcIdToken
extends AbstractOAuth2Token
implements IdTokenClaimAccessor {
    private static final long serialVersionUID = -1840734870428968020L;
    private final Map<String, Object> claims;

    public OidcIdToken(String tokenValue, Instant issuedAt, Instant expiresAt, Map<String, Object> claims) {
        super(tokenValue, issuedAt, expiresAt);
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder withTokenValue(String tokenValue) {
        return new Builder(tokenValue);
    }

    public static final class Builder {
        private String tokenValue;
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        private Builder(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        public Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public Builder claim(String name, Object value) {
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public Builder accessTokenHash(String accessTokenHash) {
            return this.claim("at_hash", accessTokenHash);
        }

        public Builder audience(Collection<String> audience) {
            return this.claim("aud", audience);
        }

        public Builder authTime(Instant authenticatedAt) {
            return this.claim("auth_time", authenticatedAt);
        }

        public Builder authenticationContextClass(String authenticationContextClass) {
            return this.claim("acr", authenticationContextClass);
        }

        public Builder authenticationMethods(List<String> authenticationMethods) {
            return this.claim("amr", authenticationMethods);
        }

        public Builder authorizationCodeHash(String authorizationCodeHash) {
            return this.claim("c_hash", authorizationCodeHash);
        }

        public Builder authorizedParty(String authorizedParty) {
            return this.claim("azp", authorizedParty);
        }

        public Builder expiresAt(Instant expiresAt) {
            return this.claim("exp", expiresAt);
        }

        public Builder issuedAt(Instant issuedAt) {
            return this.claim("iat", issuedAt);
        }

        public Builder issuer(String issuer) {
            return this.claim("iss", issuer);
        }

        public Builder nonce(String nonce) {
            return this.claim("nonce", nonce);
        }

        public Builder subject(String subject) {
            return this.claim("sub", subject);
        }

        public OidcIdToken build() {
            Instant iat = this.toInstant(this.claims.get("iat"));
            Instant exp = this.toInstant(this.claims.get("exp"));
            return new OidcIdToken(this.tokenValue, iat, exp, this.claims);
        }

        private Instant toInstant(Object timestamp) {
            if (timestamp != null) {
                Assert.isInstanceOf(Instant.class, (Object)timestamp, (String)"timestamps must be of type Instant");
            }
            return (Instant)timestamp;
        }
    }
}

