/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.mappers;

import java.security.Principal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.MutablePrincipalRoleMapper;
import org.infinispan.security.mappers.SecurityActions;

@Scope(value=Scopes.GLOBAL)
public class ClusterRoleMapper
implements MutablePrincipalRoleMapper {
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    InternalCacheRegistry internalCacheRegistry;
    public static final String CLUSTER_ROLE_MAPPER_CACHE = "org.infinispan.ROLES";
    private Cache<String, RoleSet> clusterRoleMap;
    private Cache<String, RoleSet> clusterRoleReadMap;

    @Start
    void start() {
        this.initializeInternalCache();
        this.clusterRoleMap = this.cacheManager.getCache(CLUSTER_ROLE_MAPPER_CACHE);
        this.clusterRoleReadMap = this.clusterRoleMap.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD, Flag.CACHE_MODE_LOCAL);
    }

    @Override
    public Set<String> principalToRoles(Principal principal) {
        if (this.clusterRoleReadMap == null) {
            return Collections.singleton(principal.getName());
        }
        RoleSet roleSet = (RoleSet)this.clusterRoleReadMap.get(principal.getName());
        if (roleSet != null && !roleSet.roles.isEmpty()) {
            return roleSet.roles;
        }
        return Collections.singleton(principal.getName());
    }

    private void initializeInternalCache() {
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(this.cacheManager);
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.clustering().cacheMode(cacheMode).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).security().authorization().disable();
        this.internalCacheRegistry.registerInternalCache(CLUSTER_ROLE_MAPPER_CACHE, cfg.build(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT));
    }

    @Override
    public void grant(String roleName, String principalName) {
        RoleSet roleSet = this.clusterRoleMap.computeIfAbsent(principalName, n -> new RoleSet());
        roleSet.roles.add(roleName);
        this.clusterRoleMap.put(principalName, roleSet);
    }

    @Override
    public void deny(String roleName, String principalName) {
        RoleSet roleSet = this.clusterRoleMap.computeIfAbsent(principalName, n -> new RoleSet());
        roleSet.roles.remove(roleName);
        this.clusterRoleMap.put(principalName, roleSet);
    }

    @Override
    public Set<String> list(String principalName) {
        RoleSet roleSet = (RoleSet)this.clusterRoleReadMap.get(principalName);
        if (roleSet != null) {
            return Collections.unmodifiableSet(roleSet.roles);
        }
        return Collections.singleton(principalName);
    }

    @Override
    public String listAll() {
        StringBuilder sb = new StringBuilder();
        CloseableIterator closeableIterator = this.clusterRoleReadMap.values().iterator();
        while (closeableIterator.hasNext()) {
            RoleSet set = (RoleSet)closeableIterator.next();
            sb.append(set.roles.toString());
        }
        return sb.toString();
    }

    @ProtoTypeId(value=1010)
    public static class RoleSet {
        @ProtoField(number=1, collectionImplementation=HashSet.class)
        final Set<String> roles;

        RoleSet() {
            this(new HashSet<String>());
        }

        @ProtoFactory
        RoleSet(Set<String> roles) {
            this.roles = roles;
        }

        public Set<String> getRoles() {
            return this.roles;
        }
    }
}

