/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentCleaner;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.support.AbstractScmAccessor;
import org.springframework.cloud.config.server.support.AbstractScmAccessorProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public abstract class AbstractScmEnvironmentRepository
extends AbstractScmAccessor
implements EnvironmentRepository,
SearchPathLocator,
Ordered {
    private final EnvironmentCleaner cleaner = new EnvironmentCleaner();
    private int order = Integer.MAX_VALUE;
    private final ObservationRegistry observationRegistry;

    public AbstractScmEnvironmentRepository(ConfigurableEnvironment environment, ObservationRegistry observationRegistry) {
        super(environment);
        this.observationRegistry = observationRegistry;
    }

    public AbstractScmEnvironmentRepository(ConfigurableEnvironment environment, AbstractScmAccessorProperties properties, ObservationRegistry observationRegistry) {
        super(environment, properties);
        this.order = properties.getOrder();
        this.observationRegistry = observationRegistry;
    }

    @Override
    public synchronized Environment findOne(String application, String profile, String label) {
        return this.findOne(application, profile, label, false);
    }

    @Override
    public synchronized Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        Environment environment = new Environment(application, StringUtils.commaDelimitedListToStringArray((String)profile), label, "", "");
        for (String l : this.splitAndReorder(label)) {
            Environment e = this.findOneInternal(application, profile, l, includeOrigin);
            environment.addAll(e.getPropertySources());
            environment.setVersion(this.concat(e.getVersion(), environment.getVersion()));
        }
        return this.cleaner.clean(environment, this.getWorkingDirectory().toURI().toString(), this.getUri());
    }

    private Environment findOneInternal(String application, String profile, String label, boolean includeOrigin) {
        NativeEnvironmentRepository delegate = new NativeEnvironmentRepository(this.getEnvironment(), new NativeEnvironmentProperties(), this.observationRegistry);
        SearchPathLocator.Locations locations = this.getLocations(application, profile, label);
        delegate.setSearchLocations(locations.getLocations());
        Environment environment = delegate.findOne(application, profile, "", includeOrigin);
        environment.setVersion(locations.getVersion());
        return environment;
    }

    private List<String> splitAndReorder(String label) {
        List<String> labels = Arrays.stream(StringUtils.commaDelimitedListToStringArray((String)label)).filter(StringUtils::hasText).collect(Collectors.toList());
        if (labels.isEmpty()) {
            labels.add(label);
            return labels;
        }
        Collections.reverse(labels);
        return labels;
    }

    private String concat(String first, String second) {
        if (StringUtils.hasText((String)first) && StringUtils.hasText((String)second)) {
            return first + "," + second;
        }
        if (StringUtils.hasText((String)first)) {
            return first;
        }
        if (StringUtils.hasText((String)second)) {
            return second;
        }
        return "";
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

