/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.jdbc;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.metadata.CompositeDataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JdbcTemplate.class, AbstractRoutingDataSource.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnEnabledHealthIndicator(value="db")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DataSourceHealthIndicatorProperties.class})
public class DataSourceHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<AbstractHealthIndicator, DataSource>
implements InitializingBean {
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;
    private DataSourcePoolMetadataProvider poolMetadataProvider;

    public DataSourceHealthContributorAutoConfiguration(Map<String, DataSource> dataSources, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
        this.metadataProviders = metadataProviders.orderedStream().collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        this.poolMetadataProvider = new CompositeDataSourcePoolMetadataProvider(this.metadataProviders);
    }

    @Bean
    @ConditionalOnMissingBean(name={"dbHealthIndicator", "dbHealthContributor"})
    public HealthContributor dbHealthContributor(Map<String, DataSource> dataSources, DataSourceHealthIndicatorProperties dataSourceHealthIndicatorProperties) {
        if (dataSourceHealthIndicatorProperties.isIgnoreRoutingDataSources()) {
            Map<String, DataSource> filteredDatasources = dataSources.entrySet().stream().filter(e -> !(e.getValue() instanceof AbstractRoutingDataSource)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return (HealthContributor)this.createContributor(filteredDatasources);
        }
        return (HealthContributor)this.createContributor(dataSources);
    }

    @Override
    protected AbstractHealthIndicator createIndicator(DataSource source) {
        if (source instanceof AbstractRoutingDataSource) {
            return new RoutingDataSourceHealthIndicator();
        }
        return new DataSourceHealthIndicator(source, this.getValidationQuery(source));
    }

    private String getValidationQuery(DataSource source) {
        DataSourcePoolMetadata poolMetadata = this.poolMetadataProvider.getDataSourcePoolMetadata(source);
        return poolMetadata != null ? poolMetadata.getValidationQuery() : null;
    }

    static class RoutingDataSourceHealthIndicator
    extends AbstractHealthIndicator {
        RoutingDataSourceHealthIndicator() {
        }

        protected void doHealthCheck(Health.Builder builder) throws Exception {
            builder.unknown().withDetail("routing", (Object)true);
        }
    }
}

