/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.Scheduler;
import akka.annotation.InternalApi;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$ClusterLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterLogClass$;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterSettings$;
import akka.cluster.ClusterUserAction;
import akka.cluster.ClusterUserAction$PrepareForShutdown$;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.JoinConfigCompatChecker;
import akka.cluster.JoinConfigCompatChecker$;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogMarker;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011-w!\u00024h\u0011\u0003ag!\u00028h\u0011\u0003y\u0007bBA\b\u0003\u0011\u0005AQ\u0015\u0005\b\tO\u000bA\u0011\tCU\u0011\u001d!9+\u0001C!\tgCq\u0001\"0\u0002\t\u0003\"y\fC\u0004\u0005B\u0006!\t\u0005b1\t\u0015\u0011\u001d\u0017A1A\u0005\u0006\u001d\u0014I\u0004\u0003\u0005\u0005J\u0006\u0001\u000bQ\u0002B\u001e\r\u0011qw\rA?\t\u0015\u0005\r\u0011B!b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u000e%\u0011\t\u0011)A\u0005\u0003\u000fAq!a\u0004\n\t\u0003\t\t\u0002C\u0005\u0002\u0016%\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011qD\u0005!\u0002\u0013\tI\u0002C\u0005\u0002\"%\u0011\r\u0011\"\u0003\u0002$!A\u00111F\u0005!\u0002\u0013\t)\u0003C\u0005\u0002.%\u0011\r\u0011\"\u0001\u00020!A\u0011qG\u0005!\u0002\u0013\t\t\u0004C\u0004\u0002:%!\t!a\u000f\t\u000f\u0005\r\u0013\u0002\"\u0001\u0002F!9\u00111M\u0005\u0005\u0002\u0005\u0015\u0004bBA?\u0013\u0011\u0005\u0011q\u0010\u0005\n\u0003GK!\u0019!C\u0005\u0003KC\u0001\"a.\nA\u0003%\u0011q\u0015\u0005\n\u0003sK!\u0019!C\u0005\u0003wC\u0001\"!3\nA\u0003%\u0011Q\u0018\u0005\n\u0003\u0017L\u0001\u0019!C\u0005\u0003\u001bD\u0011\"a7\n\u0001\u0004%I!!8\t\u0011\u0005%\u0018\u0002)Q\u0005\u0003\u001fD\u0011\"a;\n\u0005\u0004%\t!!<\t\u0011\u0005m\u0018\u0002)A\u0005\u0003_D\u0011\"!@\n\u0005\u0004%\t!!<\t\u0011\u0005}\u0018\u0002)A\u0005\u0003_D!B!\u0001\n\u0011\u000b\u0007I\u0011\u0001B\u0002\u0011\u001d\u0011Y!\u0003C\u0005\u0005\u001bA!Ba\u0004\n\u0005\u0004%\ta\u001aB\t\u0011!\u0011I\"\u0003Q\u0001\n\tM\u0001\"\u0003B\u000e\u0013\t\u0007I\u0011\u0002B\u000f\u0011!\u0011)#\u0003Q\u0001\n\t}\u0001B\u0003B\u0014\u0013\t\u0007I\u0011A4\u0003\u001e!A!\u0011F\u0005!\u0002\u0013\u0011y\u0002\u0003\u0006\u0003,%\u0011\r\u0011\"\u0001h\u0005[A\u0001B!\u000e\nA\u0003%!q\u0006\u0005\b\u0005oIA\u0011\u0001B\u001d\u0011\u001d\u0011\t%\u0003C\u0001\u0005\u0007BqAa\u0015\n\t\u0003\u0011)\u0006C\u0004\u0003^%!\tAa\u0018\t\u000f\tu\u0013\u0002\"\u0001\u0003\u0016\"9!1W\u0005\u0005\u0002\tU\u0006b\u0002BZ\u0013\u0011\u0005!\u0011\u0018\u0005\b\u0005\u0013LA\u0011\u0001Bf\u0011\u001d\u0011\t.\u0003C\u0001\u0005'DqA!7\n\t\u0003\u0011i\u0001C\u0004\u0003\\&!IA!8\t\u000f\t\u0005\u0018\u0002\"\u0001\u0003d\"9!\u0011]\u0005\u0005\u0002\te\bbBB\u0002\u0013\u0011\u00051Q\u0001\u0005\b\u0007\u0013IA\u0011AB\u0006\u0011\u001d\u0019y!\u0003C\u0001\u0007#Aqaa\u0004\n\t\u0003\u0019)\u0003C\u0004\u00048%!\ta!\u000f\t\u000f\r]\u0012\u0002\"\u0001\u0004F!91\u0011J\u0005\u0005\u0002\r-\u0003\u0002CB,\u0013\u0011\u0005qM!\u0004\t\u000f\r\u0015\u0014\u0002\"\u0003\u0003\u000e\u001dA1qM\u0005\t\u0002\u001d\u001cIG\u0002\u0005\u0004n%A\taZB8\u0011\u001d\tya\u0011C\u0001\t;3qa!\u001c\n\u0001\u001d\u001c\u0019\b\u0003\u0006\u0002:\u0016\u0013\t\u0011)A\u0005\u0003{Cq!a\u0004F\t\u0003\u0019)\bC\u0004\u0004z\u0015#\tA!\u000f\t\u000f\rmT\t\"\u0001\u0004~!911P#\u0005\u0002\r\r\u0005bBB>\u000b\u0012\u00051Q\u0012\u0005\b\u0007w*E\u0011ABL\u0011\u001d\u0019\u0019+\u0012C\u0001\u0007KCqaa)F\t\u0003\u0019I\u000bC\u0004\u0004$\u0016#\taa.\t\u000f\r\rV\t\"\u0001\u0004>\"911U#\u0005\u0002\r\u0015\u0007bBBR\u000b\u0012\u00051Q\u001a\u0005\b\u0007G+E\u0011ABl\u0011\u001d\u0019\u0019+\u0012C\u0001\u0007CDqa!<F\t\u0003\u0019y\u000fC\u0004\u0004n\u0016#\taa=\t\u000f\r5X\t\"\u0001\u0004z\"91Q^#\u0005\u0002\u0011\u0005\u0001bBBw\u000b\u0012\u0005A\u0011\u0002\u0005\b\u0007[,E\u0011\u0001C\n\u0011\u001d!i\"\u0012C\u0001\t?Aq\u0001\"\bF\t\u0003!\u0019\u0003C\u0004\u0005\u001e\u0015#\t\u0001\"\u000b\t\u000f\u0011uQ\t\"\u0001\u00050!9AQD#\u0005\u0002\u0011]\u0002b\u0002C\u000f\u000b\u0012\u0005A\u0011\t\u0005\b\t;)E\u0011\u0001C.\u0011\u001d!i\"\u0012C\u0001\tGBq\u0001\"\bF\t\u0003!i\u0007C\u0004\u0005z\u0015#I\u0001b\u001f\t\u000f\u0011eT\t\"\u0003\u0005\u0016\u000691\t\\;ti\u0016\u0014(B\u00015j\u0003\u001d\u0019G.^:uKJT\u0011A[\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u00055\fQ\"A4\u0003\u000f\rcWo\u001d;feN)\u0011\u0001\u001d<\u0005 B\u0011\u0011\u000f^\u0007\u0002e*\t1/A\u0003tG\u0006d\u0017-\u0003\u0002ve\n1\u0011I\\=SK\u001a\u00042a\u001e>}\u001b\u0005A(BA=j\u0003\u0015\t7\r^8s\u0013\tY\bPA\u0006FqR,gn]5p]&#\u0007CA7\n'\rI\u0001O \t\u0003o~L1!!\u0001y\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\\\u000b\u0003\u0003\u000f\u00012a^A\u0005\u0013\r\tY\u0001\u001f\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u0019A0a\u0005\t\u000f\u0005\rA\u00021\u0001\u0002\b\u0005A1/\u001a;uS:<7/\u0006\u0002\u0002\u001aA\u0019Q.a\u0007\n\u0007\u0005uqMA\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\fk_&t7i\u001c8gS\u001e\u001cu.\u001c9bi\u000eCWmY6feV\u0011\u0011Q\u0005\t\u0004[\u0006\u001d\u0012bAA\u0015O\n9\"j\\5o\u0007>tg-[4D_6\u0004\u0018\r^\"iK\u000e\\WM]\u0001\u0019U>LgnQ8oM&<7i\\7qCR\u001c\u0005.Z2lKJ\u0004\u0013!E:fY\u001a,f.[9vK\u0006#GM]3tgV\u0011\u0011\u0011\u0007\t\u0004[\u0006M\u0012bAA\u001bO\niQK\\5rk\u0016\fE\r\u001a:fgN\f!c]3mMVs\u0017.];f\u0003\u0012$'/Z:tA\u0005Y1/\u001a7g\u0003\u0012$'/Z:t+\t\ti\u0004E\u0002x\u0003\u007fI1!!\u0011y\u0005\u001d\tE\r\u001a:fgN\fab]3mM\u0012\u000bG/Y\"f]R,'/\u0006\u0002\u0002HA!\u0011\u0011JA/\u001d\u0011\tY%!\u0017\u000f\t\u00055\u0013q\u000b\b\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111K6\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0017B\u00015j\u0013\r\tYfZ\u0001\u0010\u00072,8\u000f^3s'\u0016$H/\u001b8hg&!\u0011qLA1\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0004\u00037:\u0017!C:fY\u001a\u0014v\u000e\\3t+\t\t9\u0007\u0005\u0004\u0002j\u0005E\u0014q\u000f\b\u0005\u0003W\ni\u0007E\u0002\u0002PIL1!a\u001cs\u0003\u0019\u0001&/\u001a3fM&!\u00111OA;\u0005\r\u0019V\r\u001e\u0006\u0004\u0003_\u0012\b\u0003BA5\u0003sJA!a\u001f\u0002v\t11\u000b\u001e:j]\u001e\fAbZ3u'\u0016dgMU8mKN,\"!!!\u0011\r\u0005\r\u0015QRA<\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015\u0001B;uS2T!!a#\u0002\t)\fg/Y\u0005\u0005\u0003g\n)\tK\u0004\u0017\u0003#\u000bi*a(\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&s\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b)J\u0001\u0004o_^\f'O\\\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003C\u000ba\"\\:h{\u0011,\u0007O]3dCR,G-A\u0007`SN$VM]7j]\u0006$X\rZ\u000b\u0003\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003c\u000b))\u0001\u0006d_:\u001cWO\u001d:f]RLA!!.\u0002,\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fabX5t)\u0016\u0014X.\u001b8bi\u0016$\u0007%A\u0002m_\u001e,\"!!0\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1j\u0003\u0015)g/\u001a8u\u0013\u0011\t9-!1\u0003)5\u000b'o[3s\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002\u0015\rdWo\u001d;fe*k\u00070\u0006\u0002\u0002PB)\u0011/!5\u0002V&\u0019\u00111\u001b:\u0003\r=\u0003H/[8o!\ri\u0017q[\u0005\u0004\u00033<'AC\"mkN$XM\u001d&nq\u0006q1\r\\;ti\u0016\u0014(*\u001c=`I\u0015\fH\u0003BAp\u0003K\u00042!]Aq\u0013\r\t\u0019O\u001d\u0002\u0005+:LG\u000fC\u0005\u0002hr\t\t\u00111\u0001\u0002P\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\rdWo\u001d;fe*k\u0007\u0010I\u0001\u0010M\u0006LG.\u001e:f\t\u0016$Xm\u0019;peV\u0011\u0011q\u001e\t\u0007\u0003c\f90!\u0010\u000e\u0005\u0005M(bAA{S\u00061!/Z7pi\u0016LA!!?\u0002t\n9b)Y5mkJ,G)\u001a;fGR|'OU3hSN$(/_\u0001\u0011M\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe\u0002\nac\u0019:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN]\u0001\u0018GJ|7o\u001d#d\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe\u0002\nq\u0002Z8x]&tw\r\u0015:pm&$WM]\u000b\u0003\u0005\u000b\u00012!\u001cB\u0004\u0013\r\u0011Ia\u001a\u0002\u0010\t><h.\u001b8h!J|g/\u001b3fe\u0006\u00112\r[3dW\u0006+Ho\u001c#po:,6/Y4f)\t\ty.A\u0005tG\",G-\u001e7feV\u0011!1\u0003\t\u0004o\nU\u0011b\u0001B\fq\nI1k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013AD2mkN$XM\u001d#bK6|gn]\u000b\u0003\u0005?\u00012a\u001eB\u0011\u0013\r\u0011\u0019\u0003\u001f\u0002\t\u0003\u000e$xN\u001d*fM\u0006y1\r\\;ti\u0016\u0014H)Y3n_:\u001c\b%A\u0006dYV\u001cH/\u001a:D_J,\u0017\u0001D2mkN$XM]\"pe\u0016\u0004\u0013\u0001\u0003:fC\u00124\u0016.Z<\u0016\u0005\t=\u0002cA7\u00032%\u0019!1G4\u0003\u001f\rcWo\u001d;feJ+\u0017\r\u001a,jK^\f\u0011B]3bIZKWm\u001e\u0011\u0002\u0019%\u001cH+\u001a:nS:\fG/\u001a3\u0016\u0005\tm\u0002cA9\u0003>%\u0019!q\b:\u0003\u000f\t{w\u000e\\3b]\u0006)1\u000f^1uKV\u0011!Q\t\t\u0005\u0005\u000f\u0012iED\u0002n\u0005\u0013J1Aa\u0013h\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u0011yE!\u0015\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\u0007\t-s-\u0001\u0006tK24W*Z7cKJ,\"Aa\u0016\u0011\u00075\u0014I&C\u0002\u0003\\\u001d\u0014a!T3nE\u0016\u0014\u0018!C:vEN\u001c'/\u001b2f)\u0019\tyN!\u0019\u0003f!9!1M\u0018A\u0002\t}\u0011AC:vEN\u001c'/\u001b2fe\"9!qM\u0018A\u0002\t%\u0014A\u0001;p!\u0015\t(1\u000eB8\u0013\r\u0011iG\u001d\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0007\u0002B9\u0005w\u0002b!!\u001b\u0003t\t]\u0014\u0002\u0002B;\u0003k\u0012Qa\u00117bgN\u0004BA!\u001f\u0003|1\u0001A\u0001\u0004B?\u0005K\n\t\u0011!A\u0003\u0002\t}$aA0%cE!!\u0011\u0011BD!\r\t(1Q\u0005\u0004\u0005\u000b\u0013(a\u0002(pi\"Lgn\u001a\t\u0004c\n%\u0015b\u0001BFe\n\u0019\u0011I\\=)\u0007=\u0012y\t\u0005\u0003\u0002\u0014\nE\u0015\u0002\u0002BJ\u0003+\u0013qA^1sCJ<7\u000f\u0006\u0005\u0002`\n]%\u0011\u0014BR\u0011\u001d\u0011\u0019\u0007\ra\u0001\u0005?AqAa'1\u0001\u0004\u0011i*\u0001\tj]&$\u0018.\u00197Ti\u0006$X-T8eKB!!q\tBP\u0013\u0011\u0011\tK!\u0015\u00039M+(m]2sSB$\u0018n\u001c8J]&$\u0018.\u00197Ti\u0006$X-T8eK\"9!q\r\u0019A\u0002\t\u0015\u0006#B9\u0003l\t\u001d\u0006\u0007\u0002BU\u0005[\u0003b!!\u001b\u0003t\t-\u0006\u0003\u0002B=\u0005[#ABa,\u0003$\u0006\u0005\t\u0011!B\u0001\u0005\u007f\u00121a\u0018\u00133Q\r\u0001$qR\u0001\fk:\u001cXOY:de&\u0014W\r\u0006\u0003\u0002`\n]\u0006b\u0002B2c\u0001\u0007!q\u0004\u000b\u0007\u0003?\u0014YL!0\t\u000f\t\r$\u00071\u0001\u0003 !9!q\r\u001aA\u0002\t}\u0006\u0007\u0002Ba\u0005\u000b\u0004b!!\u001b\u0003t\t\r\u0007\u0003\u0002B=\u0005\u000b$ABa2\u0003>\u0006\u0005\t\u0011!B\u0001\u0005\u007f\u00121a\u0018\u00134\u0003]\u0019XM\u001c3DkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$X\r\u0006\u0003\u0002`\n5\u0007b\u0002Bhg\u0001\u0007!qD\u0001\te\u0016\u001cW-\u001b<fe\u0006!!n\\5o)\u0011\tyN!6\t\u000f\t]G\u00071\u0001\u0002>\u00059\u0011\r\u001a3sKN\u001c\u0018!\b9sKB\f'/\u001a$pe\u001a+H\u000e\\\"mkN$XM]*ikR$wn\u001e8\u0002\u0013\u0019LG\u000e\u001c'pG\u0006dG\u0003BA\u001f\u0005?DqAa67\u0001\u0004\ti$A\u0007k_&t7+Z3e\u001d>$Wm\u001d\u000b\u0005\u0003?\u0014)\u000fC\u0004\u0003h^\u0002\rA!;\u0002\u0013M,W\r\u001a(pI\u0016\u001c\bC\u0002Bv\u0005k\fi$\u0004\u0002\u0003n*!!q\u001eBy\u0003%IW.\\;uC\ndWMC\u0002\u0003tJ\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119P!<\u0003\u0007M+\u0017\u000f\u0006\u0003\u0002`\nm\bb\u0002Btq\u0001\u0007!Q \t\u0007\u0003\u0007\u0013y0!\u0010\n\t\r\u0005\u0011Q\u0011\u0002\u0005\u0019&\u001cH/A\u0003mK\u00064X\r\u0006\u0003\u0002`\u000e\u001d\u0001b\u0002Bls\u0001\u0007\u0011QH\u0001\u0005I><h\u000e\u0006\u0003\u0002`\u000e5\u0001b\u0002Blu\u0001\u0007\u0011QH\u0001\u0013e\u0016<\u0017n\u001d;fe>sW*Z7cKJ,\u0006/\u0006\u0003\u0004\u0014\r\u0005B\u0003BAp\u0007+A\u0001ba\u0006<\t\u0003\u00071\u0011D\u0001\u0005G>$W\rE\u0003r\u00077\u0019y\"C\u0002\u0004\u001eI\u0014\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0005\u0005s\u001a\t\u0003B\u0004\u0004$m\u0012\rAa \u0003\u0003Q#B!a8\u0004(!91\u0011\u0006\u001fA\u0002\r-\u0012\u0001C2bY2\u0014\u0017mY6\u0011\t\r521G\u0007\u0003\u0007_QAa!\r\u0002\n\u0006!A.\u00198h\u0013\u0011\u0019)da\f\u0003\u0011I+hN\\1cY\u0016\fqC]3hSN$XM](o\u001b\u0016l'-\u001a:SK6|g/\u001a3\u0016\t\rm21\t\u000b\u0005\u0003?\u001ci\u0004\u0003\u0005\u0004\u0018u\"\t\u0019AB !\u0015\t81DB!!\u0011\u0011Iha\u0011\u0005\u000f\r\rRH1\u0001\u0003\u0000Q!\u0011q\\B$\u0011\u001d\u0019IC\u0010a\u0001\u0007W\tAB]3n_R,\u0007+\u0019;i\u001f\u001a$Ba!\u0014\u0004TA\u0019qoa\u0014\n\u0007\rE\u0003PA\u0005BGR|'\u000fU1uQ\"91QK A\u0002\t}\u0011\u0001C1di>\u0014(+\u001a4\u0002\u0011MDW\u000f\u001e3po:D3\u0001QB.!\u0011\u0019if!\u0019\u000e\u0005\r}#bAALS&!11MB0\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0002\u001d\rdwn]3TG\",G-\u001e7fe\u0006i1\t\\;ti\u0016\u0014Hj\\4hKJ\u00042aa\u001bD\u001b\u0005I!!D\"mkN$XM\u001d'pO\u001e,'oE\u0002D\u0007c\u00022aa\u001bF'\t)\u0005\u000f\u0006\u0003\u0004r\r]\u0004bBA]\u000f\u0002\u0007\u0011QX\u0001\u000fSN$UMY;h\u000b:\f'\r\\3e\u0003!awn\u001a#fEV<G\u0003BAp\u0007\u007fBqa!!J\u0001\u0004\t9(A\u0004nKN\u001c\u0018mZ3\u0015\r\u0005}7QQBE\u0011\u001d\u00199I\u0013a\u0001\u0003o\n\u0001\u0002^3na2\fG/\u001a\u0005\b\u0007\u0017S\u0005\u0019\u0001BD\u0003\u0011\t'oZ\u0019\u0015\u0011\u0005}7qRBI\u0007'Cqaa\"L\u0001\u0004\t9\bC\u0004\u0004\f.\u0003\rAa\"\t\u000f\rU5\n1\u0001\u0003\b\u0006!\u0011M]43))\tyn!'\u0004\u001c\u000eu5q\u0014\u0005\b\u0007\u000fc\u0005\u0019AA<\u0011\u001d\u0019Y\t\u0014a\u0001\u0005\u000fCqa!&M\u0001\u0004\u00119\tC\u0004\u0004\"2\u0003\rAa\"\u0002\t\u0005\u0014xmM\u0001\bY><\u0017J\u001c4p)\u0011\tyna*\t\u000f\r\u0005U\n1\u0001\u0002xQ1\u0011q\\BV\u0007kCqa!,O\u0001\u0004\u0019y+\u0001\u0004nCJ\\WM\u001d\t\u0005\u0003\u007f\u001b\t,\u0003\u0003\u00044\u0006\u0005'!\u0003'pO6\u000b'o[3s\u0011\u001d\u0019\tI\u0014a\u0001\u0003o\"b!a8\u0004:\u000em\u0006bBBD\u001f\u0002\u0007\u0011q\u000f\u0005\b\u0007\u0017{\u0005\u0019\u0001BD)!\tyna0\u0004B\u000e\r\u0007bBBW!\u0002\u00071q\u0016\u0005\b\u0007\u000f\u0003\u0006\u0019AA<\u0011\u001d\u0019Y\t\u0015a\u0001\u0005\u000f#\u0002\"a8\u0004H\u000e%71\u001a\u0005\b\u0007\u000f\u000b\u0006\u0019AA<\u0011\u001d\u0019Y)\u0015a\u0001\u0005\u000fCqa!&R\u0001\u0004\u00119\t\u0006\u0006\u0002`\u000e=7\u0011[Bj\u0007+Dqa!,S\u0001\u0004\u0019y\u000bC\u0004\u0004\bJ\u0003\r!a\u001e\t\u000f\r-%\u000b1\u0001\u0003\b\"91Q\u0013*A\u0002\t\u001dECCAp\u00073\u001cYn!8\u0004`\"91qQ*A\u0002\u0005]\u0004bBBF'\u0002\u0007!q\u0011\u0005\b\u0007+\u001b\u0006\u0019\u0001BD\u0011\u001d\u0019\tk\u0015a\u0001\u0005\u000f#B\"a8\u0004d\u000e\u00158q]Bu\u0007WDqa!,U\u0001\u0004\u0019y\u000bC\u0004\u0004\bR\u0003\r!a\u001e\t\u000f\r-E\u000b1\u0001\u0003\b\"91Q\u0013+A\u0002\t\u001d\u0005bBBQ)\u0002\u0007!qQ\u0001\u000bY><w+\u0019:oS:<G\u0003BAp\u0007cDqa!!V\u0001\u0004\t9\b\u0006\u0004\u0002`\u000eU8q\u001f\u0005\b\u0007\u000f3\u0006\u0019AA<\u0011\u001d\u0019YI\u0016a\u0001\u0005\u000f#\u0002\"a8\u0004|\u000eu8q \u0005\b\u0007[;\u0006\u0019ABX\u0011\u001d\u00199i\u0016a\u0001\u0003oBqaa#X\u0001\u0004\u00119\t\u0006\u0005\u0002`\u0012\rAQ\u0001C\u0004\u0011\u001d\u00199\t\u0017a\u0001\u0003oBqaa#Y\u0001\u0004\u00119\tC\u0004\u0004\u0016b\u0003\rAa\"\u0015\u0015\u0005}G1\u0002C\u0007\t\u001f!\t\u0002C\u0004\u0004.f\u0003\raa,\t\u000f\r\u001d\u0015\f1\u0001\u0002x!911R-A\u0002\t\u001d\u0005bBBK3\u0002\u0007!q\u0011\u000b\u000b\u0003?$)\u0002b\u0006\u0005\u001a\u0011m\u0001bBBD5\u0002\u0007\u0011q\u000f\u0005\b\u0007\u0017S\u0006\u0019\u0001BD\u0011\u001d\u0019)J\u0017a\u0001\u0005\u000fCqa!)[\u0001\u0004\u00119)\u0001\u0005m_\u001e,%O]8s)\u0011\ty\u000e\"\t\t\u000f\r\u00055\f1\u0001\u0002xQ1\u0011q\u001cC\u0013\tOAqa!,]\u0001\u0004\u0019y\u000bC\u0004\u0004\u0002r\u0003\r!a\u001e\u0015\r\u0005}G1\u0006C\u0017\u0011\u001d\u00199)\u0018a\u0001\u0003oBqaa#^\u0001\u0004\u00119\t\u0006\u0005\u0002`\u0012EB1\u0007C\u001b\u0011\u001d\u00199I\u0018a\u0001\u0003oBqaa#_\u0001\u0004\u00119\tC\u0004\u0004\u0016z\u0003\rAa\"\u0015\u0015\u0005}G\u0011\bC\u001e\t{!y\u0004C\u0004\u0004\b~\u0003\r!a\u001e\t\u000f\r-u\f1\u0001\u0003\b\"91QS0A\u0002\t\u001d\u0005bBBQ?\u0002\u0007!q\u0011\u000b\u0007\u0003?$\u0019\u0005\"\u0017\t\u000f\u0011\u0015\u0003\r1\u0001\u0005H\u0005)1-Y;tKB!A\u0011\nC*\u001d\u0011!Y\u0005b\u0014\u000f\t\u0005=CQJ\u0005\u0002g&\u0019A\u0011\u000b:\u0002\u000fA\f7m[1hK&!AQ\u000bC,\u0005%!\u0006N]8xC\ndWMC\u0002\u0005RIDqa!!a\u0001\u0004\t9\b\u0006\u0005\u0002`\u0012uCq\fC1\u0011\u001d!)%\u0019a\u0001\t\u000fBqaa\"b\u0001\u0004\t9\bC\u0004\u0004\f\u0006\u0004\rAa\"\u0015\u0015\u0005}GQ\rC4\tS\"Y\u0007C\u0004\u0005F\t\u0004\r\u0001b\u0012\t\u000f\r\u001d%\r1\u0001\u0002x!911\u00122A\u0002\t\u001d\u0005bBBKE\u0002\u0007!q\u0011\u000b\r\u0003?$y\u0007\"\u001d\u0005t\u0011UDq\u000f\u0005\b\t\u000b\u001a\u0007\u0019\u0001C$\u0011\u001d\u00199i\u0019a\u0001\u0003oBqaa#d\u0001\u0004\u00119\tC\u0004\u0004\u0016\u000e\u0004\rAa\"\t\u000f\r\u00056\r1\u0001\u0003\b\u0006QAn\\4Bi2+g/\u001a7\u0015\r\u0005}GQ\u0010CJ\u0011\u001d!y\b\u001aa\u0001\t\u0003\u000b\u0001\u0002\\8h\u0019\u00164X\r\u001c\t\u0005\t\u0007#iI\u0004\u0003\u0005\u0006\u0012%e\u0002BA'\t\u000fK1!a1j\u0013\u0011!Y)!1\u0002\u000f1{wmZ5oO&!Aq\u0012CI\u0005!aun\u001a'fm\u0016d'\u0002\u0002CF\u0003\u0003Dqa!!e\u0001\u0004\t9\b\u0006\u0005\u0002`\u0012]E\u0011\u0014CN\u0011\u001d\u0019i+\u001aa\u0001\u0007_Cq\u0001b f\u0001\u0004!\t\tC\u0004\u0004\u0002\u0016\u0004\r!a\u001e\u0015\u0005\r%\u0004cA<\u0005\"&\u0019A1\u0015=\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u00031\f1aZ3u)\raH1\u0016\u0005\b\u0003\u0007\u0019\u0001\u0019\u0001CW!\r9HqV\u0005\u0004\tcC(aC!di>\u00148+_:uK6$2\u0001 C[\u0011\u001d\t\u0019\u0001\u0002a\u0001\to\u00032a\u001eC]\u0013\r!Y\f\u001f\u0002\u001b\u00072\f7o]5d\u0003\u000e$xN]*zgR,W\u000e\u0015:pm&$WM]\u0001\u0007Y>|7.\u001e9\u0016\u00031\fqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0004y\u0012\u0015\u0007bBA\u0002\r\u0001\u0007\u0011qA\u0001\u001aSN\f5o]3si&sg/\u0019:jC:$8/\u00128bE2,G-\u0001\u000ejg\u0006\u001b8/\u001a:u\u0013:4\u0018M]5b]R\u001cXI\\1cY\u0016$\u0007\u0005")
public class Cluster
implements Extension {
    private DowningProvider downingProvider;
    private volatile Cluster$ClusterLogger$ ClusterLogger$module;
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final MarkerLoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile boolean bitmap$0;

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.get(classicActorSystemProvider);
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public Cluster$ClusterLogger$ ClusterLogger() {
        if (this.ClusterLogger$module == null) {
            this.ClusterLogger$lzycompute$1();
        }
        return this.ClusterLogger$module;
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private JoinConfigCompatChecker joinConfigCompatChecker() {
        return this.joinConfigCompatChecker;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public MarkerLoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.checkAutoDownUsage();
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.downingProvider;
    }

    public DowningProvider downingProvider() {
        return !this.bitmap$0 ? this.downingProvider$lzycompute() : this.downingProvider;
    }

    private void checkAutoDownUsage() {
        block3: {
            block2: {
                String string = this.settings().DowningProviderClassName();
                String string2 = "akka.cluster.AutoDowning";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                if (!this.settings().config().hasPath("auto-down-unreachable-after")) break block3;
                String string3 = this.settings().config().getString("auto-down-unreachable-after");
                String string4 = "off";
                if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block3;
            }
            this.ClusterLogger().logWarning("auto-down has been removed in Akka 2.6.0. See https://doc.akka.io/docs/akka/2.6/typed/cluster.html#downing for alternatives.");
        }
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0 & Serializable)() -> "at least one `ClusterDomainEvent` class is required");
        Predef$.MODULE$.require(to.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cluster.$anonfun$subscribe$2(x$1))), (Function0 & Serializable)() -> new StringBuilder(81).append("subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [").append(((IterableOnceOps)to.map((Function1 & Serializable)x$1 -> x$1.getName())).mkString(", ")).append("]").toString());
        InternalClusterAction.Subscribe x$12 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$12);
        this.clusterCore().$bang((Object)x$12, x$2);
    }

    public void unsubscribe(ActorRef subscriber) {
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        InternalClusterAction.SendCurrentClusterState x$1 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void join(Address address) {
        address.checkHostCharacters();
        ClusterUserAction.JoinTo x$1 = new ClusterUserAction.JoinTo(this.fillLocal(address));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void prepareForFullClusterShutdown() {
        ClusterUserAction$PrepareForShutdown$ x$1 = ClusterUserAction$PrepareForShutdown$.MODULE$;
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Address fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(Seq<Address> seedNodes) {
        seedNodes.foreach((Function1 & Serializable)x$2 -> {
            x$2.checkHostCharacters();
            return BoxedUnit.UNIT;
        });
        InternalClusterAction.JoinSeedNodes x$1 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable)address -> this.fillLocal((Address)address))));
        ActorRef x$22 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$22);
    }

    public void joinSeedNodes(java.util.List<Address> seedNodes) {
        this.joinSeedNodes((Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ClusterUserAction.Leave x$1 = new ClusterUserAction.Leave(this.fillLocal(address));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void down(Address address) {
        ClusterUserAction.Down x$1 = new ClusterUserAction.Down(this.fillLocal(address));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        InternalClusterAction.AddOnMemberUpListener x$1 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$2 = this.clusterDaemons().$bang$default$2((Object)x$1);
        this.clusterDaemons().$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(null, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            InternalClusterAction.AddOnMemberRemovedListener x$1 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$2 = this.clusterDaemons().$bang$default$2((Object)x$1);
            this.clusterDaemons().$bang((Object)x$1, x$2);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$1 = path.root();
            Address x$1 = this.selfAddress();
            String x$2 = qual$1.copy$default$2();
            actorPath = qual$1.copy(x$1, x$2).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    @InternalApi
    public void shutdown() {
        block1: {
            if (!this._isTerminated().compareAndSet(false, true)) break block1;
            this.ClusterLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1 & Serializable)x$3 -> {
                x$3.unregisterMBean();
                return BoxedUnit.UNIT;
            });
            this.ClusterLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void ClusterLogger$lzycompute$1() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.ClusterLogger$module == null) {
                this.ClusterLogger$module = new Cluster$ClusterLogger$(this);
            }
        }
    }

    private final /* synthetic */ ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$1 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$2 = timeout$1;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            ActorRef actorRef2 = this.system().deadLetters();
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public static final /* synthetic */ boolean $anonfun$subscribe$2(Class x$1) {
        return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
    }

    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        this.joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            throw new ConfigurationException(new StringBuilder(107).append("ActorSystem [").append(system).append("] needs to have 'akka.actor.provider' set to 'cluster' in the configuration, currently uses [").append(actorRefProvider.getClass().getName()).append("]").toString());
        }
        ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
        UniqueAddress uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
        this.selfUniqueAddress = uniqueAddress;
        this._isTerminated = new AtomicBoolean(false);
        this.akka$cluster$Cluster$$log = Logging$.MODULE$.withMarker((ActorSystem)system, ClusterLogClass$.MODULE$.ClusterCore(), LogSource$.MODULE$.fromAnyClass());
        this.clusterJmx = None$.MODULE$;
        this.ClusterLogger().logInfo("Starting up, Akka version [{}] ...", (Object)system.settings().ConfigVersion());
        Function0 & Serializable createFailureDetector = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
        Function0 & Serializable createFailureDetector2 = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)this.system());
        this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
        package.DurationInt durationInt = new package.DurationInt(package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.ClusterLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), (Object)BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringBuilder(31).append("akka.scheduler.tick-duration=").append(this.settings().SchedulerTickDuration().toMillis()).append("ms").toString()).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                threadFactory = monitorableThreadFactory.withName(new StringBuilder(18).append(monitorableThreadFactory.name()).append("-cluster-scheduler").toString());
            } else {
                threadFactory = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(null, systemScheduler){
                private final Scheduler systemScheduler$1;

                public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleWithFixedDelay(java.time.Duration initialDelay, java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleWithFixedDelay$default$6(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleWithFixedDelay$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleWithFixedDelay(java.time.Duration initialDelay, java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleAtFixedRate(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleAtFixedRate$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.scheduleAtFixedRate$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleAtFixedRate(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.schedule$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                }

                public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleOnce$default$5$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                }

                public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
                {
                    this.systemScheduler$1 = systemScheduler$1;
                    Scheduler.$init$((Scheduler)this);
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.joinConfigCompatChecker()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.shutdown());
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, (LoggingAdapter)this.akka$cluster$Cluster$$log());
            jmx.createMBean();
            this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
        }
        this.ClusterLogger().logInfo("Started up successfully");
    }

    public class ClusterLogger {
        private final MarkerLoggingAdapter log;
        public final /* synthetic */ Cluster $outer;

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void logDebug(String message) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isDebugEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), message);
            }
        }

        public void logDebug(String template, Object arg1) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isDebugEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
            }
        }

        public void logDebug(String template, Object arg1, Object arg2) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isDebugEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
            }
        }

        public void logDebug(String template, Object arg1, Object arg2, Object arg3) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isDebugEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
            }
        }

        public void logInfo(String message) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), message);
            }
        }

        public void logInfo(LogMarker marker, String message) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), message);
            }
        }

        public void logInfo(String template, Object arg1) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
            }
        }

        public void logInfo(String template, Object arg1, Object arg2) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1, Object arg2) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
            }
        }

        public void logInfo(String template, Object arg1, Object arg2, Object arg3) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
            block0: {
                if (!this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() || !this.log.isInfoEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
            }
        }

        public void logWarning(String message) {
            block0: {
                if (!this.log.isWarningEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), message);
            }
        }

        public void logWarning(String template, Object arg1) {
            block0: {
                if (!this.log.isWarningEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
            }
        }

        public void logWarning(LogMarker marker, String template, Object arg1) {
            block0: {
                if (!this.log.isWarningEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
            }
        }

        public void logWarning(String template, Object arg1, Object arg2) {
            block0: {
                if (!this.log.isWarningEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
            }
        }

        public void logWarning(LogMarker marker, String template, Object arg1, Object arg2) {
            block0: {
                if (!this.log.isWarningEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
            }
        }

        public void logWarning(String template, Object arg1, Object arg2, Object arg3) {
            block0: {
                if (!this.log.isWarningEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
            }
        }

        public void logError(String message) {
            block0: {
                if (!this.log.isErrorEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), message);
            }
        }

        public void logError(LogMarker marker, String message) {
            block0: {
                if (!this.log.isErrorEnabled(marker)) break block0;
                this.logAtLevel(marker, Logging$.MODULE$.ErrorLevel(), message);
            }
        }

        public void logError(String template, Object arg1) {
            block0: {
                if (!this.log.isErrorEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
            }
        }

        public void logError(String template, Object arg1, Object arg2) {
            block0: {
                if (!this.log.isErrorEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
            }
        }

        public void logError(String template, Object arg1, Object arg2, Object arg3) {
            block0: {
                if (!this.log.isErrorEnabled()) break block0;
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
            }
        }

        public void logError(Throwable cause, String message) {
            String string = this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.error(cause, "Cluster Node [{}] - {}", (Object)this.akka$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)message);
            } else {
                this.log.error(cause, "Cluster Node [{}] dc [{}] - {}", (Object)this.akka$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter(), (Object)message);
            }
        }

        public void logError(Throwable cause, String template, Object arg1) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
        }

        public void logError(Throwable cause, String template, Object arg1, Object arg2) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }

        public void logError(Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }

        private void logAtLevel(int logLevel, String message) {
            String string = this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.log(logLevel, "Cluster Node [{}] - {}", (Object)this.akka$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)message);
            } else {
                this.log.log(logLevel, "Cluster Node [{}] dc [{}] - {}", (Object)this.akka$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter(), (Object)message);
            }
        }

        private void logAtLevel(LogMarker marker, int logLevel, String message) {
            String string = this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.log(marker, logLevel, this.log.format("Cluster Node [{}] - {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.akka$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), message})));
            } else {
                this.log.log(marker, logLevel, this.log.format("Cluster Node [{}] dc [{}] - {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.akka$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), this.akka$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter(), message})));
            }
        }

        public /* synthetic */ Cluster akka$cluster$Cluster$ClusterLogger$$$outer() {
            return this.$outer;
        }

        public ClusterLogger(Cluster $outer, MarkerLoggingAdapter log) {
            this.log = log;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

