/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv.stream.reader;

import java.io.BufferedReader;
import java.io.IOException;

public class LineReader {
    private BufferedReader reader;
    private boolean keepCarriageReturns;

    public LineReader(BufferedReader reader, boolean keepCarriageReturns) {
        this.reader = reader;
        this.keepCarriageReturns = keepCarriageReturns;
    }

    public String readLine() throws IOException {
        return this.keepCarriageReturns ? this.readUntilNewline() : this.reader.readLine();
    }

    private String readUntilNewline() throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int c2 = this.reader.read();
        while (c2 > -1 && c2 != 10) {
            sb.append((char)c2);
            c2 = this.reader.read();
        }
        return sb.length() > 0 ? sb.toString() : null;
    }
}

