/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Column;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Constraint;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Ordering;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModel;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Source;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryObjectModelImpl
extends QueryImpl
implements QueryObjectModel {
    protected QueryObjectModelTree qomTree;

    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, String statement, String language) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.language = language;
        this.handler = handler;
        this.statement = statement;
        this.query = handler.createExecutableQuery(session, itemMgr, this.createQOMTree(statement, language));
        this.setInitialized();
    }

    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.node = node;
        this.handler = handler;
        if (!node.isNodeType(session.getJCRName(NameConstants.NT_QUERY))) {
            throw new InvalidQueryException("node is not of type nt:query");
        }
        this.statement = node.getProperty(session.getJCRName(NameConstants.JCR_STATEMENT)).getString();
        this.language = node.getProperty(session.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
        this.query = handler.createExecutableQuery(session, itemMgr, this.createQOMTree(this.statement, this.language));
        this.setInitialized();
    }

    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, QueryObjectModelTree qomTree, String language) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.language = language;
        this.handler = handler;
        this.qomTree = qomTree;
        this.statement = null;
        this.query = handler.createExecutableQuery(session, itemMgr, qomTree);
        this.setInitialized();
    }

    public Source getSource() {
        return this.qomTree.getSource();
    }

    public Constraint getConstraint() {
        return this.qomTree.getConstraint();
    }

    public Ordering[] getOrderings() {
        return this.qomTree.getOrderings();
    }

    public Column[] getColumns() {
        return this.qomTree.getColumns();
    }

    private QueryObjectModelTree createQOMTree(String statement, String language) throws InvalidQueryException {
        return null;
    }
}

