/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class PassphraseCredentialsProvider
extends CredentialsProvider {
    public static final String PROMPT = "Passphrase for";
    private final String passphrase;

    public PassphraseCredentialsProvider(String passphrase) {
        this.passphrase = passphrase;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.StringType && item.getPromptText().startsWith(PROMPT)) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialItem item : items) {
            if (!(item instanceof CredentialItem.StringType) || !item.getPromptText().startsWith(PROMPT)) {
                throw new UnsupportedCredentialItem(uri, item.getClass().getName() + ":" + item.getPromptText());
            }
            ((CredentialItem.StringType)item).setValue(this.passphrase);
        }
        return true;
    }
}

