/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.BorderProperty;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class CompoundBorderProperty
extends BorderProperty {
    static final long serialVersionUID = -8513525079430361312L;
    public static final int VERSION = 1;
    private LinkedList m_borders = new LinkedList();

    public CompoundBorderProperty() {
    }

    public CompoundBorderProperty(BorderProperty borderProperty) {
        this.addBorder(borderProperty);
    }

    public void addBorder(BorderProperty borderProperty) {
        if (borderProperty != null) {
            this.m_borders.addLast(borderProperty);
        }
    }

    public Border createBorder(Component component) {
        if (this.m_borders.size() == 0) {
            return null;
        }
        if (this.m_borders.size() == 1) {
            BorderProperty borderProperty = (BorderProperty)this.m_borders.getFirst();
            Border border = borderProperty.createBorder(component);
            return border;
        }
        Border border = null;
        Iterator iterator = this.m_borders.iterator();
        while (iterator.hasNext()) {
            BorderProperty borderProperty = (BorderProperty)iterator.next();
            Border border2 = borderProperty.createBorder(component);
            if (border == null) {
                border = border2;
                continue;
            }
            border = BorderFactory.createCompoundBorder(border, border2);
        }
        return border;
    }

    public boolean equals(Object object) {
        if (object instanceof CompoundBorderProperty) {
            CompoundBorderProperty compoundBorderProperty = (CompoundBorderProperty)object;
            boolean bl = super.equals(object);
            return bl && CompoundBorderProperty.isEqual(this.m_borders, compoundBorderProperty.m_borders);
        }
        return false;
    }

    public BorderProperty getBorder(int n) throws IndexOutOfBoundsException {
        return (BorderProperty)this.m_borders.get(n);
    }

    public Iterator iterator() {
        return this.m_borders.iterator();
    }

    public int size() {
        return this.m_borders.size();
    }

    public void setValue(Object object) {
        if (object instanceof CompoundBorderProperty) {
            CompoundBorderProperty compoundBorderProperty = (CompoundBorderProperty)object;
            this.m_borders.clear();
            this.m_borders.addAll(compoundBorderProperty.m_borders);
        }
    }

    public void updateBean(JETABean jETABean) {
        if (this.m_borders != null) {
            super.updateBean(jETABean);
        }
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_borders = (LinkedList)jETAObjectInput.readObject("borders");
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(BorderProperty.class));
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeObject("borders", this.m_borders);
    }

    public String toString() {
        if (this.m_borders.size() == 0) {
            return "NO BORDER";
        }
        if (this.m_borders.size() == 1) {
            BorderProperty borderProperty = (BorderProperty)this.m_borders.getFirst();
            return borderProperty.toString();
        }
        return "COMPOUND";
    }

    public int getSize() {
        return this.m_borders.size();
    }
}

