/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.AuditPreviewRow;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.report.AppEnvStatusReport;
import com.xebialabs.deployit.engine.api.dto.report.DeploymentsStatusOverview;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\rUf\u0001\u0002\u000f\u001e\u0001)B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!i\u0006A!A!\u0002\u0013q\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0003l\u0011%A\b\u00011AA\u0002\u0013%\u0011\u0010\u0003\u0006\u0002\u0006\u0001\u0001\r\u0011!Q!\n1Dq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\u0014\u0001\u0005\n\u0005u\u0005b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u0005_\u0001A\u0011\tB\u0019\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqAa.\u0001\t\u0003\u0012I\fC\u0004\u0003R\u0002!\tEa5\t\u000f\t-\b\u0001\"\u0003\u0003n\"91Q\u0006\u0001\u0005\n\r=\u0002bBB\u001f\u0001\u0011\u00053q\b\u0005\b\u0007\u0003\u0002A\u0011IB \u0011\u001d\u0019\u0019\u0005\u0001C!\u0007\u000bBqaa\u0011\u0001\t\u0003\u001aY\u0005C\u0004\u0004V\u0001!\tea\u0016\t\u000f\r=\u0004\u0001\"\u0011\u0004r!911\u0011\u0001\u0005B\r\u0015%!\u0005*fa>\u0014HoU3sm&\u001cW-S7qY*\u0011adH\u0001\u0004CBL'B\u0001\u0011\"\u0003\u0011\u0011Xm\u001d;\u000b\u0005\t\u001a\u0013\u0001B2pe\u0016T!\u0001J\u0013\u0002\u0011\u0011,\u0007\u000f\\8zSRT!AJ\u0014\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0015\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001Y\u0013\u0007\u000f\t\u0003Y=j\u0011!\f\u0006\u0003]}\tqa]3dkJ,G-\u0003\u00021[\t9\u0012IY:ue\u0006\u001cGoU3dkJ,GMU3t_V\u00148-\u001a\t\u0003eYj\u0011a\r\u0006\u0003=QR!!N\u0012\u0002\r\u0015tw-\u001b8f\u0013\t94GA\u0007SKB|'\u000f^*feZL7-\u001a\t\u0003syj\u0011A\u000f\u0006\u0003wq\nQa\u001d7gi)T\u0011!P\u0001\tOJL'P\u001f7fI&\u0011qH\u000f\u0002\b\u0019><w-\u001b8h\u0003=\u0011X\r]8si\u001e+g.\u001a:bi>\u0014\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\"\u0003\u001d\u0019XM\u001d<jG\u0016L!AR\"\u0003\u001fI+\u0007o\u001c:u\u000f\u0016tWM]1u_J\f\u0011\u0003]1hS:\fG/[8o'\u0016\u0014h/[2f!\t\u0011\u0015*\u0003\u0002K\u0007\n\t\u0002+Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002\u0019\rL'+\u001a9pg&$xN]=\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016aA:rY*\u0011\u0011kI\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA*O\u00051\u0019\u0015NU3q_NLGo\u001c:z\u0003-!\u0018m]6Be\u000eD\u0017N^3\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016aB1sG\"Lg/\u001a\u0006\u00035\u000e\nA\u0001^1tW&\u0011Al\u0016\u0002\f)\u0006\u001c8.\u0011:dQ&4X-\u0001\te_^tGn\\1e%\u0016\u001cx.\u001e:dKB\u0011q\fY\u0007\u0002;%\u0011\u0011-\b\u0002\u0011\t><h\u000e\\8bIJ+7o\\;sG\u0016\fa\u0001P5oSRtDC\u00023fM\u001eD\u0017\u000e\u0005\u0002`\u0001!)\u0001I\u0002a\u0001\u0003\")qI\u0002a\u0001\u0011\")1J\u0002a\u0001\u0019\")AK\u0002a\u0001+\")QL\u0002a\u0001=\u0006A!/Z:q_:\u001cX-F\u0001m!\tig/D\u0001o\u0015\ty\u0007/A\u0002ta&T!!\u001d:\u0002\u0011I,7\u000f^3bgfT!a\u001d;\u0002\u000b)\u0014wn]:\u000b\u0003U\f1a\u001c:h\u0013\t9hN\u0001\u0007IiR\u0004(+Z:q_:\u001cX-\u0001\u0007sKN\u0004xN\\:f?\u0012*\u0017\u000fF\u0002{\u0003\u0003\u0001\"a\u001f@\u000e\u0003qT\u0011!`\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fr\u0014A!\u00168ji\"A\u00111\u0001\u0005\u0002\u0002\u0003\u0007A.A\u0002yIE\n\u0011B]3ta>t7/\u001a\u0011)\u0007%\tI\u0001\u0005\u0003\u0002\f\u0005mQBAA\u0007\u0015\r\u0011\u0013q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0002sg*!\u0011QCA\f\u0003\t98O\u0003\u0002\u0002\u001a\u0005)!.\u0019<bq&!\u0011QDA\u0007\u0005\u001d\u0019uN\u001c;fqR\f1b]3u%\u0016\u001c\bo\u001c8tKR\u0019!0a\t\t\u000b)T\u0001\u0019\u00017\u0002\u0019M,GoQ5GS2$XM]:\u0015\u000bi\fI#!\u000e\t\u000f\u0005-2\u00021\u0001\u0002.\u0005\u00012/Z1sG\"\u0004\u0016M]1nKR,'o\u001d\t\u0005\u0003_\t\t$D\u0001Z\u0013\r\t\u0019$\u0017\u0002\u001d\u0003J\u001c\u0007.\u001b<fIR\u000b7o[*fCJ\u001c\u0007\u000eU1sC6,G/\u001a:t\u0011\u001d\t9d\u0003a\u0001\u0003s\tAcY8oM&<WO]1uS>t\u0017\n^3n\u0013\u0012\u001c\bCBA\u001e\u0003\u000b\nI%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006LA!a\u0012\u0002>\t!A*[:u!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(g\u0005\u0019A\r^8\n\t\u0005M\u0013Q\n\u0002\u0014\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017\nZ\u0001\rgR\u0014X-Y7SKB|'\u000f^\u000b\u0005\u00033\nY\u0007\u0006\u0005\u0002\\\u0005u\u0014QRAL!\u0019\ti&a\u0019\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\ni$\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003K\nyF\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0003S\nY\u0007\u0004\u0001\u0005\u000f\u00055DB1\u0001\u0002p\t\tA+\u0005\u0003\u0002r\u0005]\u0004cA>\u0002t%\u0019\u0011Q\u000f?\u0003\u000f9{G\u000f[5oOB\u001910!\u001f\n\u0007\u0005mDPA\u0002B]fDq!a \r\u0001\u0004\t\t)A\u0006qC\u001eLgnZ'bs\n,\u0007#B>\u0002\u0004\u0006\u001d\u0015bAACy\n1q\n\u001d;j_:\u0004B!a\u0013\u0002\n&!\u00111RA'\u0005\u0019\u0001\u0016mZ5oO\"9\u0011q\u0012\u0007A\u0002\u0005E\u0015a\u00032vS2$\u0007+\u0019:b[N\u0004ra_AJ\u0003\u000f\u000bi#C\u0002\u0002\u0016r\u0014\u0011BR;oGRLwN\\\u0019\t\u000f\u0005\u0005D\u00021\u0001\u0002\u001aB910a%\u0002.\u0005m\u0013AG:ue\u0016\fW\u000eR3qY>LX.\u001a8u)\u0006\u001c8NU3q_J$HCGAP\u0003O\u000b9,a/\u0002@\u0006-\u0017q]Av\u0003_\fyPa\u0001\u0003\u000e\tE\u0001CBA/\u0003G\n\t\u000b\u0005\u0003\u0002L\u0005\r\u0016\u0002BAS\u0003\u001b\u0012\u0001\u0004R3qY>LX.\u001a8u)\u0006\u001c8NU3q_J$H*\u001b8f\u0011\u001d\tI+\u0004a\u0001\u0003W\u000bQAY3hS:\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0004c\u0006E&B\u0001\u0010\"\u0013\u0011\t),a,\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003sk\u0001\u0019AAV\u0003\r)g\u000e\u001a\u0005\b\u0003{k\u0001\u0019AAA\u0003\u0019\u0001\u0018mZ5oO\"9\u0011\u0011Y\u0007A\u0002\u0005\r\u0017!B8sI\u0016\u0014\bCBA\u001e\u0003\u000b\n)\r\u0005\u0003\u0002L\u0005\u001d\u0017\u0002BAe\u0003\u001b\u0012\u0001b\u0014:eKJLgn\u001a\u0005\b\u0003\u001bl\u0001\u0019AAh\u0003\u0015)8/\u001a:t!\u0019\tY$!\u0012\u0002RB!\u00111[Aq\u001d\u0011\t).!8\u0011\u0007\u0005]G0\u0004\u0002\u0002Z*\u0019\u00111\\\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u000e`\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0018Q\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}G\u0010C\u0004\u0002j6\u0001\r!a4\u0002\u0015Q\f7o[*uCR,7\u000fC\u0004\u0002n6\u0001\r!a4\u0002\u0013Q\f7o\u001b+za\u0016\u001c\bbBAy\u001b\u0001\u0007\u00111_\u0001\nM\u0016$8\r['pI\u0016\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0004\u0003s\u001c\u0014!C3yK\u000e,H/[8o\u0013\u0011\ti0a>\u0003\u0013\u0019+Go\u00195N_\u0012,\u0007b\u0002B\u0001\u001b\u0001\u0007\u0011\u0011[\u0001\u0007i\u0006\u001c8.\u00133\t\u000f\t\u0015Q\u00021\u0001\u0003\b\u0005qqN\u001c7z'V\u001c7-Z:tMVd\u0007cA>\u0003\n%\u0019!1\u0002?\u0003\u000f\t{w\u000e\\3b]\"9!qB\u0007A\u0002\u0005E\u0017AC<pe.,'OT1nK\"9\u0011qG\u0007A\u0002\u0005e\u0012!D4fiR\u000b7o\u001b*fa>\u0014H\u000f\u0006\u000e\u0002 \n]!\u0011\u0004B\u000e\u0005;\u0011yB!\t\u0003$\t\u0015\"q\u0005B\u0015\u0005W\u0011i\u0003C\u0004\u0002*:\u0001\r!a+\t\u000f\u0005ef\u00021\u0001\u0002,\"9\u0011Q\u0018\bA\u0002\u0005\u001d\u0005bBAa\u001d\u0001\u0007\u00111\u0019\u0005\b\u0003\u001bt\u0001\u0019AAh\u0011\u001d\tIO\u0004a\u0001\u0003\u001fDq!!<\u000f\u0001\u0004\ty\rC\u0004\u0002r:\u0001\r!a=\t\u000f\t\u0005a\u00021\u0001\u0002R\"9!Q\u0001\bA\u0002\t\u001d\u0001b\u0002B\b\u001d\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003oq\u0001\u0019AA\u001d\u0003I!wn\u001e8m_\u0006$G+Y:l%\u0016\u0004xN\u001d;\u0015-\u0005E'1\u0007B\u001b\u0005o\u0011IDa\u000f\u0003>\t}\"\u0011\tB\"\u0005\u000bBq!!+\u0010\u0001\u0004\tY\u000bC\u0004\u0002:>\u0001\r!a+\t\u000f\u0005\u0005w\u00021\u0001\u0002D\"9\u0011QZ\bA\u0002\u0005=\u0007bBAu\u001f\u0001\u0007\u0011q\u001a\u0005\b\u0003[|\u0001\u0019AAh\u0011\u001d\u0011\ta\u0004a\u0001\u0003#DqA!\u0002\u0010\u0001\u0004\u00119\u0001C\u0004\u0003\u0010=\u0001\r!!5\t\u000f\u0005]r\u00021\u0001\u0002:!ZqB!\u0013\u0003^\t}#1\rB3!\u0011\u0011YE!\u0017\u000e\u0005\t5#\u0002\u0002B(\u0005#\n!\"\u00198o_R\fG/[8o\u0015\u0011\u0011\u0019F!\u0016\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u0005/\"\u0018aD:qe&twM\u001a:b[\u0016<xN]6\n\t\tm#Q\n\u0002\u000e)J\fgn]1di&|g.\u00197\u0002\u000bY\fG.^3\"\u0005\t\u0005\u0014a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'/\u0001\u0005sK\u0006$wJ\u001c7z3\u0005\t\u0001fC\b\u0003j\tM$Q\u000fB=\u0005w\u0002BAa\u001b\u0003p5\u0011!Q\u000e\u0006\u0003c~IAA!\u001d\u0003n\t9qk\u001c:lI&\u0014\u0018A\u00029sK\u001aL\u00070\t\u0002\u0003x\u0005AAm\\<oY>\fG-A\u0003dY\u0016\fg\u000e\n\u0002\u0003~%!!q\u0010BA\u0003\u0019\tEjV!Z'*!!1\u0011BC\u0003\u0015\u0019E.Z1o\u0015\u0011\u00119I!\u001c\u0002\u000f]{'o\u001b3je\u000692\u000f\u001e:fC6\u001cuN\u001c;s_2$\u0016m]6SKB|'\u000f\u001e\u000b\u0019\u0005\u001b\u0013)Ja&\u0003\u001a\nu%\u0011\u0015BR\u0005K\u00139K!+\u0003,\n5\u0006CBA/\u0003G\u0012y\t\u0005\u0003\u0002L\tE\u0015\u0002\u0002BJ\u0003\u001b\u0012QcQ8oiJ|G\u000eV1tWJ+\u0007o\u001c:u\u0019&tW\rC\u0004\u0002*B\u0001\r!a+\t\u000f\u0005e\u0006\u00031\u0001\u0002,\"9!1\u0014\tA\u0002\u0005=\u0017AB:uCR,7\u000fC\u0004\u0003 B\u0001\r!!5\u0002\u0011Q\f7o\u001b(b[\u0016Dq!!=\u0011\u0001\u0004\t\u0019\u0010C\u0004\u0002NB\u0001\r!a4\t\u000f\u0005\u0005\u0007\u00031\u0001\u0002D\"9!q\u0002\tA\u0002\u0005E\u0007b\u0002B\u0001!\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003{\u0003\u0002\u0019AAA\u0011\u001d\u0011y\u000b\u0005a\u0001\u0005c\u000bq\u0001^1sO\u0016$8\u000f\u0005\u0004\u0002<\tM\u0016\u0011[\u0005\u0005\u0005k\u000biDA\u0002TKR\fQcZ3u\u0007>tGO]8m)\u0006\u001c8n\u001d*fa>\u0014H\u000f\u0006\r\u0003\u000e\nm&Q\u0018B`\u0005\u0003\u0014\u0019M!2\u0003H\n%'1\u001aBg\u0005\u001fDq!!+\u0012\u0001\u0004\tY\u000bC\u0004\u0002:F\u0001\r!a+\t\u000f\tm\u0015\u00031\u0001\u0002P\"9!qT\tA\u0002\u0005E\u0007bBAy#\u0001\u0007\u00111\u001f\u0005\b\u0003\u001b\f\u0002\u0019AAh\u0011\u001d\t\t-\u0005a\u0001\u0003\u0007DqAa\u0004\u0012\u0001\u0004\t\t\u000eC\u0004\u0003\u0002E\u0001\r!!5\t\u000f\u0005u\u0016\u00031\u0001\u0002\b\"9!qV\tA\u0002\tE\u0016A\u00073po:dw.\u00193D_:$(o\u001c7UCN\\7OU3q_J$H\u0003FAi\u0005+\u00149N!7\u0003\\\nu'q\u001cBq\u0005G\u0014)\u000fC\u0004\u0002*J\u0001\r!a+\t\u000f\u0005e&\u00031\u0001\u0002,\"9!1\u0014\nA\u0002\u0005=\u0007b\u0002BP%\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003\u001b\u0014\u0002\u0019AAh\u0011\u001d\t\tM\u0005a\u0001\u0003\u0007DqAa\u0004\u0013\u0001\u0004\t\t\u000eC\u0004\u0003\u0002I\u0001\r!!5\t\u000f\t=&\u00031\u0001\u00032\"Z!C!\u0013\u0003^\t}#1\rB3Q-\u0011\"\u0011\u000eB:\u0005k\u0012IHa\u001f\u0002/1L7\u000f^!mY\u000eK7o\u00144UsB,wI]8va\u0016$GC\u0002Bx\u0007\u0017\u0019\t\u0003\u0005\u0005\u0003r\nm(q`Ai\u001b\t\u0011\u0019P\u0003\u0003\u0003v\n]\u0018!C5n[V$\u0018M\u00197f\u0015\r\u0011I\u0010`\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u007f\u0005g\u00141!T1q!\u0011\u0019\taa\u0002\u000e\u0005\r\r!\u0002BB\u0003\u0003\u0003\nA\u0001\\1oO&!1\u0011BB\u0002\u0005\u001dIe\u000e^3hKJDqa!\u0004\u0014\u0001\u0004\u0019y!\u0001\u0004dSRK\b/\u001a\t\u0005\u0007#\u0019i\"\u0004\u0002\u0004\u0014)!1QCB\f\u0003\u001d\u0011XM\u001a7fGRT1AHB\r\u0015\r\u0019YbI\u0001\u0007a2,x-\u001b8\n\t\r}11\u0003\u0002\u0005)f\u0004X\rC\u0004\u0004$M\u0001\ra!\n\u0002\u0011\u001d,G\u000fT1cK2\u0004ra_AJ\u0007O\t\t\u000eE\u0002N\u0007SI1aa\u000bO\u0005\r\u001auN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c#bi\u0006<\u0016\u000e\u001e5J]R,'O\\1m\u0013\u0012\fQ\u0002\\5tiRK\b/\u001a)bi\"\u001cH\u0003CA\u001d\u0007c\u0019Ida\u000f\t\u000f\rMB\u00031\u0001\u00046\u0005Y\u0011M]2iSZ,GmQ5t!!\t\u0019na\u000e\u0003\u0000\u0006=\u0017\u0002\u0002B\u007f\u0003KDqaa\t\u0015\u0001\u0004\u0019)\u0003C\u0004\u0004\u000eQ\u0001\raa\u0004\u0002!1L7\u000f^#om&\u0014xN\\7f]R\u001cHCAA\u001d\u0003Aa\u0017n\u001d;BaBd\u0017nY1uS>t7/A\ne_^tGn\\1e\u0003V$\u0017\u000e\u001e*fa>\u0014H\u000f\u0006\u0002\u0002R\"ZqC!\u0013\u0003^\t}#1\rB3Q-9\"\u0011\u000eB:\u0005k\u0012IHa\u001f\u0015\t\u0005E7Q\n\u0005\b\u0007\u001fB\u0002\u0019AAh\u0003\u001d1w\u000e\u001c3feND3\u0002\u0007B%\u0005;\u0012yFa\u0019\u0003f!Z\u0001D!\u001b\u0003t\tU$\u0011\u0010B>\u0003I\u0001(/\u001a<jK^\fU\u000fZ5u%\u0016\u0004xN\u001d;\u0015\u0011\re3\u0011MB2\u0007K\u0002b!!\u0018\u0002d\rm\u0003\u0003BA&\u0007;JAaa\u0018\u0002N\ty\u0011)\u001e3jiB\u0013XM^5foJ{w\u000fC\u0004\u0004Pe\u0001\r!a4\t\u000f\u0005\u0005\u0017\u00041\u0001\u0002D\"9\u0011QX\rA\u0002\u0005\u001d\u0005fC\r\u0003J\tu#q\fB2\u0005KBs!\u0007B5\u0005g\u001aY'\t\u0002\u0004n\u00059\u0001O]3wS\u0016<\u0018!E4fiN#\u0018\r^;t\u001fZ,'O^5foR111OB@\u0007\u0003\u0003Ba!\u001e\u0004|5\u00111q\u000f\u0006\u0005\u0007s\ni%\u0001\u0004sKB|'\u000f^\u0005\u0005\u0007{\u001a9HA\rEKBdw._7f]R\u001c8\u000b^1ukN|e/\u001a:wS\u0016<\bbBAU5\u0001\u0007\u00111\u0016\u0005\b\u0003sS\u0002\u0019AAV\u0003=9W\r^!qa\u0016sgo\u0015;biV\u001cHCBBD\u0007\u001f\u001b\t\n\u0005\u0004\u0002<\u0005\u00153\u0011\u0012\t\u0005\u0007k\u001aY)\u0003\u0003\u0004\u000e\u000e]$AE!qa\u0016sgo\u0015;biV\u001c(+\u001a9peRDq!!+\u001c\u0001\u0004\tY\u000bC\u0004\u0002:n\u0001\r!a+)\u0007\u0001\u0019)\n\u0005\u0003\u0004\u0018\u000e\rVBABM\u0015\u0011\u0011yea'\u000b\t\ru5qT\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u0019\tK!\u0016\u0002\u000b\t,\u0017M\\:\n\t\r\u00156\u0011\u0014\u0002\n\u0003V$xn^5sK\u0012D3\u0001ABU!\u0011\u0019Yk!-\u000e\u0005\r5&\u0002BBX\u0005+\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019\u0019l!,\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(configurationItemIds).asScala()).toList().flatten(Predef$.MODULE$.$conforms())));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> pagingMaybe, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limitedMaybe = pagingMaybe.map((Function1 & Serializable)paging -> new Tuple2(paging, (Object)$this.paginationService.getLimitedPaging((Paging)paging)));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limitedMaybe.map((Function1 & Serializable)x$3 -> (Paging)x$3._2()).getOrElse((Function0 & Serializable)() -> new Paging()));
        limitedMaybe.foreach((Function1 & Serializable)limitedPaging -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)limitedPaging._1(), (Paging)limitedPaging._2(), this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Nil()).asJava(), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Option<Paging> paging, java.util.Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            params.withUniqueId(taskId);
            Object object = users != null && !users.isEmpty() ? params.forUsers((java.util.Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Paging paging, java.util.Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, taskId, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, java.util.Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, taskId, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(ControlTaskReportLineField$.MODULE$.allFields()).asJava(), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.listInternal(params)).asScala().map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((Set)cisInRepository.keySet());
        List onlyInArchive = ((IterableOnceOps)archivedCis.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)CollectionConverters$.MODULE$.ListHasAsScala(paths).asScala().filter((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : package$.MODULE$.Nil();
            return nil$;
        })).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((IterableOnceOps)archivedCis.view().filterKeys((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatMap((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala())).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)((StrictOptimizedSeqOps)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$5 -> new ConfigurationItemId(x$5, ciType))).asJava();
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getEnvironments()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getApplications()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(Collections.emptyList(), this.downloadResource);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport(java.util.List<String> folders) {
        return this.reportGenerator.generateAuditReport(folders, this.downloadResource);
    }

    @Workdir(prefix="preview")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Stream<AuditPreviewRow> previewAuditReport(java.util.List<String> folders, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging) {
        AuditPreviewReport previewReport = this.reportGenerator.previewAuditReport(folders, order, paging);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> previewReport.total());
        return previewReport.currentPageData().stream();
    }

    public DeploymentsStatusOverview getStatusOverview(Date begin, Date end) {
        return this.reportGenerator.buildStatusOverview(begin, end);
    }

    public java.util.List<AppEnvStatusReport> getAppEnvStatus(Date begin, Date end) {
        return this.reportGenerator.buildAppEnvStatusReport(begin, end);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

