/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.cluster.client;

import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.rzo.netty.ahessian.application.cluster.service.ClusterService;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryBuilder;
import org.rzo.netty.ahessian.bootstrap.DefaultClient;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.mcast.discovery.DiscoveryClient;
import org.rzo.netty.mcast.discovery.DiscoveryListener;

public class ClusterClient {
    List<InetSocketAddress> _seeds;
    AtomicReference<DefaultClient<ClusterService>> _remoteClient = new AtomicReference();
    String _clientName;
    String _clusterName;
    boolean _useDiscovery = false;
    volatile boolean _stop = true;
    static Executor _executor = Executors.newCachedThreadPool();
    DiscoveryClient _discovery;
    Object _data;
    AtomicBoolean _connecting = new AtomicBoolean(false);
    AtomicBoolean _discovering = new AtomicBoolean(false);
    ClusterService.ClusterEventListener _listener;

    public ClusterClient(String clusterName, String myName, InetSocketAddress ... seeds) throws Exception {
        this._clusterName = clusterName;
        this._clientName = myName;
        if (seeds == null || seeds.length == 0) {
            this._useDiscovery = true;
            this._seeds = new CopyOnWriteArrayList<InetSocketAddress>();
            this._discovery = new DiscoveryClient();
            this._discovery.setName(clusterName);
            this._discovery.setDebug(true);
            this._discovery.addListener(new DiscoveryListener(){

                @Override
                public void newHost(String name, String host) {
                    int port;
                    String[] x = host.split("&");
                    String hostName = x[1];
                    InetSocketAddress remoteAddress = new InetSocketAddress(hostName, port = Integer.parseInt(x[2]));
                    if (!ClusterClient.this._seeds.contains(remoteAddress)) {
                        ClusterClient.this._seeds.add(remoteAddress);
                        System.out.println("adding seed " + remoteAddress);
                        if (!ClusterClient.this.isConnected()) {
                            ClusterClient.this.connect();
                        }
                    }
                }
            });
            this._discovery.init();
        } else {
            this._seeds = Arrays.asList(seeds);
        }
    }

    public ClusterClient(InetSocketAddress ... seeds) throws Exception {
        this("DefaultCluster", ClusterClient.createName(), seeds);
    }

    public ClusterClient(String clusterName, String clientName) throws Exception {
        this(clusterName, clientName, new InetSocketAddress[0]);
    }

    public ClusterClient(String clusterName) throws Exception {
        this(clusterName, ClusterClient.createName());
    }

    public ClusterClient() throws Exception {
        this("DefaultCluster", ClusterClient.createName());
    }

    public void setData(Object data) {
        this._data = data;
    }

    public void setListener(ClusterService.ClusterEventListener listener) {
        this._listener = listener;
    }

    public synchronized void join() throws Exception {
        if (!this._stop) {
            return;
        }
        this._stop = false;
        if (this._useDiscovery) {
            this.startDiscovery();
        }
        this.connect();
    }

    public synchronized void leave() {
        if (this._stop) {
            return;
        }
        this._stop = true;
        if (this._useDiscovery) {
            this.stopDiscovery();
        }
        this.disconnect();
    }

    public boolean isConnected() {
        return this._remoteClient.get() != null;
    }

    public List<ClusterService.Member> getMembers() {
        DefaultClient<ClusterService> client = this._remoteClient.get();
        if (client == null) {
            return null;
        }
        ClusterService proxy = null;
        try {
            proxy = client.proxy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (proxy == null) {
            return null;
        }
        try {
            return proxy.getMembers();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String createName() {
        return ClusterClient.getHostName() + "-" + System.currentTimeMillis();
    }

    public static String getHostName() {
        String hostname = "Unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            System.out.println("Hostname can not be resolved");
        }
        return hostname;
    }

    private void connect() {
        _executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ClusterClient.this.connectInternal();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void connectInternal() throws Exception {
        if (!this._connecting.compareAndSet(false, true)) {
            return;
        }
        while (!this._stop && !this.isConnected()) {
            for (InetSocketAddress seed : this._seeds) {
                if (!this._stop && !this.connectToSeed(seed)) continue;
                break;
            }
            if (this._stop || this.isConnected()) continue;
            Thread.sleep(5000L);
        }
        this._connecting.set(false);
    }

    private boolean connectToSeed(InetSocketAddress seed) {
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        options.put("sync", Boolean.valueOf(true));
        options.put("timeout", Long.valueOf(200000L));
        ChannelPipelineFactoryBuilder builder = new ChannelPipelineFactoryBuilder().serviceThreads(10).rpcServiceInterface(ClusterService.class).clientHeartbeat(30000L).serviceOptions(options);
        builder.debug();
        HashSet<String> channelOptions = new HashSet<String>();
        channelOptions.add("TCP_NODELAY");
        final DefaultClient client = new DefaultClient(NioSocketChannel.class, builder, channelOptions);
        client.setRemoteAddress(seed.getHostName(), seed.getPort());
        client.connectedListener(new HessianRPCServiceHandler.ConnectListener(){

            @Override
            public void run() {
                try {
                    ((ClusterService)client.proxy()).join(ClusterClient.this._clusterName, ClusterClient.this._clientName, ClusterClient.this._data, ClusterClient.this._listener);
                    ClusterClient.this._remoteClient.compareAndSet(null, client);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void run(Channel channel) {
            }
        });
        client.disconnectedListener(new HessianRPCServiceHandler.ConnectListener(){

            @Override
            public void run() {
                try {
                    ((ClusterService)client.proxy()).leave(ClusterClient.this._clientName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                client.close();
                if (!ClusterClient.this._stop && ClusterClient.this._remoteClient.compareAndSet(client, null)) {
                    ClusterClient.this.connect();
                }
            }

            @Override
            public void run(Channel channel) {
            }
        });
        try {
            client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this._remoteClient.get() != null;
    }

    private void disconnect() {
        DefaultClient<ClusterService> client = this._remoteClient.get();
        if (client != null) {
            try {
                client.proxy().leave(this._clientName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            client.close();
        }
        this._remoteClient.set(null);
    }

    private void startDiscovery() throws Exception {
        if (!this._discovering.compareAndSet(false, true)) {
            return;
        }
        this._discovery.start();
    }

    private void stopDiscovery() {
        if (!this._discovering.compareAndSet(true, false)) {
            return;
        }
        this._discovery.stop();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ClusterClient.createName());
        ClusterClient cluster = new ClusterClient(new InetSocketAddress("127.0.0.1", 15010), new InetSocketAddress("127.0.0.1", 15011), new InetSocketAddress("127.0.0.1", 15012));
        cluster.join();
        while (!cluster.isConnected()) {
            Thread.sleep(100L);
        }
        System.out.println("my name " + cluster._clientName);
        System.out.println("members " + cluster.getMembers());
        Thread.sleep(10000L);
        System.exit(0);
    }
}

