/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.utils.MyReentrantLock;

public class PushInputStreamConsumer
extends ChannelInboundHandlerAdapter {
    volatile Lock _lock = new MyReentrantLock();
    AtomicInteger _consumerThreadsCount = new AtomicInteger(0);
    volatile InputStreamConsumer _consumer;
    volatile Executor _executor;

    public PushInputStreamConsumer(InputStreamConsumer consumer, Executor executor) {
        this._consumer = consumer;
        this._executor = executor;
    }

    public void channelRead(final ChannelHandlerContext ctx, final Object msg) throws Exception {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                String tName = Thread.currentThread().getName();
                try {
                    PushInputStreamConsumer.this.run(ctx, msg);
                }
                finally {
                    Thread.currentThread().setName(tName);
                    PushInputStreamConsumer.this._consumerThreadsCount.decrementAndGet();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ChannelHandlerContext ctx, Object evt) {
        if (this._consumer.isBufferEmpty()) {
            return;
        }
        if (this._consumerThreadsCount.incrementAndGet() > 2) {
            this._consumerThreadsCount.decrementAndGet();
            return;
        }
        Thread.currentThread().setName("ahessian-PushInputStreamConsumer-#" + this._consumerThreadsCount.get());
        this._lock.lock();
        try {
            this._consumer.consume(ctx, (InputStream)evt);
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
        finally {
            this._consumerThreadsCount.decrementAndGet();
            this._lock.unlock();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this._lock.lock();
        try {
            this._consumer.setContext(ctx);
        }
        finally {
            this._lock.unlock();
        }
        ctx.fireChannelActive();
    }
}

