/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.MessageIterator;
import org.jgroups.util.Util;

@MBean(description="Serializes entire message into the payload of another message")
public class SERIALIZE
extends Protocol {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    protected Address local_addr;

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        Buffer serialized_msg = Util.streamableToBuffer(msg);
        Message tmp = msg.copy(false, false).setBuffer(serialized_msg);
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr != null) {
            tmp.putHeader(GMS_ID, hdr);
        }
        return this.down_prot.down(tmp);
    }

    @Override
    public Object up(Message msg) {
        try {
            Message ret = SERIALIZE.deserialize(msg);
            return this.up_prot.up(ret);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed deserialize message from %s", msg.src()), e);
        }
    }

    @Override
    public void up(MessageBatch batch) {
        MessageIterator it = batch.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            try {
                Message deserialized_msg = SERIALIZE.deserialize(msg);
                it.replace(deserialized_msg);
            }
            catch (Exception e) {
                this.log.error("failed deserializing message", e);
                it.remove();
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected static Message deserialize(Message msg) throws Exception {
        try {
            Message ret = Util.streamableFromBuffer(Message::new, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            if (ret.getDest() == null) {
                ret.setDest(msg.getDest());
            }
            if (ret.getSrc() == null) {
                ret.setSrc(msg.getSrc());
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(String.format("failed deserialize message from %s", msg.src()), e);
        }
    }
}

