/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesAndPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesRequest;
import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@RestController
@RequestMapping(value={"/v1/permissions/all"})
@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\u0007\u000e\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003<\u0001\u0011\u0005q\rC\u0003<\u0001\u0011\u0005A\u0010C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002T!9\u00111\u0005\u0001\u0005\u0002\u0005%\u0004bBA\u0012\u0001\u0011\u0005\u0011Q\u0011\u0002\u0015!\u0016\u0014X.[:tS>t7i\u001c8ue>dG.\u001a:\u000b\u00059y\u0011\u0001B5na2T!\u0001E\t\u0002\u0005Y\f$B\u0001\n\u0014\u0003\u0011\u0011Xm\u001d;\u000b\u0005Q)\u0012aA1qS*\u0011acF\u0001\fa\u0016\u0014X.[:tS>t7O\u0003\u0002\u00193\u00051A-\u001a9m_fT!AG\u000e\u0002\u000f\u0011Lw-\u001b;bY*\tA$\u0001\u0002bS\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fM\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\t9#&D\u0001)\u0015\tIS#A\u0004tKJ4\u0018nY3\n\u0005-B#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f1D]3gKJ,gnY3e!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007CA\u0014/\u0013\ty\u0003FA\u000eSK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\\*feZL7-Z\u0001\u0018O2|'-\u00197QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016\u0004\"a\n\u001a\n\u0005MB#aF$m_\n\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q!a\u0007O\u001d;!\t9\u0004!D\u0001\u000e\u0011\u0015)C\u00011\u0001'\u0011\u0015aC\u00011\u0001.\u0011\u0015\u0001D\u00011\u00012\u0003\u0011\u0011X-\u00193\u0015\u0005u\u001a\u0005C\u0001 B\u001b\u0005y$B\u0001!\u0012\u0003\r!Go\\\u0005\u0003\u0005~\u0012aCU8mK^KG\u000f\u001b)fe6L7o]5p]N$Eo\u001c\u0005\u0006\t\u0016\u0001\r!R\u0001\te>dWMT1nKB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u0011\u000e\u0003%S!AS\u000f\u0002\rq\u0012xn\u001c;?\u0013\ta\u0015%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'\"Q\t\u0019\u0015\u000b\u0005\u0002S;6\t1K\u0003\u0002U+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Y;\u0016\u0001\u00022j]\u0012T!\u0001W-\u0002\u0007],'M\u0003\u0002[7\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001]\u0003\ry'oZ\u0005\u0003=N\u0013A\u0002U1uQZ\u000b'/[1cY\u0016DC!\u00021dIB\u0011!+Y\u0005\u0003EN\u0013!bR3u\u001b\u0006\u0004\b/\u001b8h\u0003\u00151\u0018\r\\;fY\u0005)\u0017%\u00014\u0002\u0017=Z(o\u001c7f\u001d\u0006lW- \u000b\u0003QF\u00042!\u001b8>\u001d\tQGN\u0004\u0002IW&\t!%\u0003\u0002nC\u00059\u0001/Y2lC\u001e,\u0017BA8q\u0005\u0011a\u0015n\u001d;\u000b\u00055\f\u0003\"\u0002:\u0007\u0001\u0004\u0019\u0018!\u0003:pY\u0016t\u0015-\\3t!\rIg.\u0012\u0015\u0003cV\u0004\"A\u0015<\n\u0005]\u001c&a\u0003*fcV,7\u000f\u001e\"pIfDCA\u00021ds2\n!0I\u0001|\u0003\u0019y#o\u001c7fgR)Q0a\u0003\u0002\u0012A!a0a\u0002>\u001b\u0005y(\u0002BA\u0001\u0003\u0007\ta\u0001Z8nC&t'bAA\u00033\u0006!A-\u0019;b\u0013\r\tIa \u0002\u0005!\u0006<W\r\u0003\u0004\u0002\u000e\u001d\u0001\ra]\u0001\u0006]\u0006lWm\u001d\u0015\u0004\u0003\u0017)\bbBA\n\u000f\u0001\u0007\u0011QC\u0001\ta\u0006<W-\u00192mKB\u0019a0a\u0006\n\u0007\u0005eqP\u0001\u0005QC\u001e,\u0017M\u00197fQ\u00159\u0001mYA\u000fY\t\ty\"\t\u0002\u0002\"\u0005iqF]8mKN|c-\u001b7uKJ\fqb\u00195fG.\u0004VM]7jgNLwN\u001c\u000b\u0005\u0003O\ti\u0003E\u0002!\u0003SI1!a\u000b\"\u0005\u001d\u0011un\u001c7fC:Dq!a\f\t\u0001\u0004\t\t$\u0001\fdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o%\u0016\fX/Z:u!\rq\u00141G\u0005\u0004\u0003ky$AF\"iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8SKF,Xm\u001d;)\u0007\u00055R\u000f\u000b\u0003\u0002.\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BAA#\u0003\u0015Q\u0017M^1y\u0013\u0011\tI%a\u0010\u0003\u000bY\u000bG.\u001b3)\u000b!\u00017-!\u0014-\u0005\u0005=\u0013EAA)\u0003\u0019y3\r[3dWR!\u0011qEA+\u0011\u001d\ty#\u0003a\u0001\u0003/\u00022APA-\u0013\r\tYf\u0010\u0002%\u0007\",7m\u001b)fe6L7o]5p]^KG\u000f\u001b)sS:\u001c\u0017\u000e]1mgJ+\u0017/^3ti\"\u001a\u0011QK;)\t\u0005U\u00131\b\u0015\u0006\u0013\u0001\u001c\u00171\r\u0017\u0003\u0003K\n#!a\u001a\u0002#=\u001a\u0007.Z2l_A\u0014\u0018N\\2ja\u0006d7\u000f\u0006\u0003\u0002l\u0005E\u0004C\u0002$\u0002n\u0015\u000b9#C\u0002\u0002p=\u00131!T1q\u0011\u001d\tyC\u0003a\u0001\u0003g\u00022APA;\u0013\r\t9h\u0010\u0002%\u0007\",7m\u001b)fe6L7o]5p]^KG\u000f\u001b*fM\u0016\u0014XM\\2fgJ+\u0017/^3ti\"\u001a\u0011\u0011O;)\t\u0005E\u00141\b\u0015\u0006\u0015\u0001\u001c\u0017q\u0010\u0017\u0003\u0003\u0003\u000b#!a!\u0002#=\u0012XMZ3sK:\u001cWm]\u0018dQ\u0016\u001c7\u000e\u0006\u0003\u0002l\u0005\u001d\u0005bBA\u0018\u0017\u0001\u0007\u0011\u0011\u0012\t\u0004}\u0005-\u0015bAAG\u007f\t\t4\t[3dWB+'/\\5tg&|gnV5uQJ+g-\u001a:f]\u000e,7/\u00118e!JLgnY5qC2\u001c(+Z9vKN$\bfAADk\"\"\u0011qQA\u001eQ\u0015Y\u0001mYAKY\t\t9*\t\u0002\u0002\u001a\u0006arF]3gKJ,gnY3t_\rDWmY60aJLgnY5qC2\u001c\bF\u0002\u0001\u0002\u001e\u000e\f\u0019\u000bE\u0002S\u0003?K1!!)T\u00059\u0011V-];fgRl\u0015\r\u001d9j]\u001ed#!!*\"\u0005\u0005\u001d\u0016aE\u0018wc=\u0002XM]7jgNLwN\\:0C2d\u0007f\u0001\u0001\u0002,B\u0019!+!,\n\u0007\u0005=6K\u0001\bSKN$8i\u001c8ue>dG.\u001a:")
public class PermissionController {
    private final RoleService roleService;
    private final ReferencedPermissionService referencedPermissionService;
    private final GlobalPermissionService globalPermissionService;

    @GetMapping(value={"/{roleName}"})
    public RoleWithPermissionsDto read(@PathVariable String roleName) {
        List globalPermissions = this.globalPermissionService.read(roleName).map((Function1 & Serializable)x$1 -> x$1.permissionName());
        Map referencedPermissions = this.referencedPermissionService.read(roleName).groupBy((Function1 & Serializable)x$2 -> x$2.reference());
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        List referencedPermissionsDto = ((IterableOnceOps)referencedPermissions.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$3 -> x$3.permissionName())))).toList();
        return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), globalPermissions, referencedPermissionsDto);
    }

    @GetMapping(value={"/roles"})
    public List<RoleWithPermissionsDto> read(@RequestBody List<String> roleNames) {
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$4 -> x$4.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$5 -> x$5.role().name());
        List roles = this.roleService.read(roleNames);
        return roles.map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$6 -> x$6.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$7 -> x$7.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
    }

    @GetMapping(value={"/roles/filter"})
    public Page<RoleWithPermissionsDto> read(@RequestBody List<String> names, Pageable pageable) {
        Page roles = this.roleService.read(names, pageable);
        List roleNames = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)x$8 -> x$8.name());
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$9 -> x$9.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$10 -> x$10.role().name());
        List dtos = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$11 -> x$11.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$12 -> x$12.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
        return new PageImpl(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dtos).asJava(), pageable, roles.getTotalElements());
    }

    @GetMapping(value={"/check"})
    public boolean checkPermission(@Valid @RequestBody CheckPermissionRequest checkPermissionRequest) {
        return BoxesRunTime.unboxToBoolean((Object)checkPermissionRequest.referenceMaybe().map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles())));
    }

    @GetMapping(value={"/check/principals"})
    public boolean checkPermission(@Valid @RequestBody CheckPermissionWithPrincipalsRequest checkPermissionRequest) {
        return BoxesRunTime.unboxToBoolean((Object)checkPermissionRequest.referenceMaybe().map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals())));
    }

    @GetMapping(value={"/references/check"})
    public Map<String, Object> checkPermission(@Valid @RequestBody CheckPermissionWithReferencesRequest checkPermissionRequest) {
        return checkPermissionRequest.references().isEmpty() ? (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles())))})) : checkPermissionRequest.references().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @GetMapping(value={"/references/check/principals"})
    public Map<String, Object> checkPermission(@Valid @RequestBody CheckPermissionWithReferencesAndPrincipalsRequest checkPermissionRequest) {
        return checkPermissionRequest.references().isEmpty() ? (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals())))})) : checkPermissionRequest.references().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public PermissionController(RoleService roleService, ReferencedPermissionService referencedPermissionService, GlobalPermissionService globalPermissionService) {
        this.roleService = roleService;
        this.referencedPermissionService = referencedPermissionService;
        this.globalPermissionService = globalPermissionService;
    }
}

