/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.comparison;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.springframework.stereotype.Component;

@Component
public class Comparator {
    private static final String PASSWORD_OBFUSCATION = "********";

    public Map<String, List<String>> compare(ConfigurationItem reference, List<ConfigurationItem> entities) {
        ComputingLinkedMap comparison = new ComputingLinkedMap(entities.size() + 1);
        this.checkCiTypes(reference.getType(), entities);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)reference.getType());
        int nrCi = 0;
        ArrayList<ConfigurationItem> entitiesToCompare = new ArrayList<ConfigurationItem>();
        entitiesToCompare.add(reference);
        entitiesToCompare.addAll(entities);
        for (ConfigurationItem compareEntity : entitiesToCompare) {
            this.writeFields(comparison, compareEntity, nrCi);
            this.writeProperties(comparison, compareEntity, descriptor, nrCi);
            ++nrCi;
        }
        LinkedHashMap<String, List<String>> retval = new LinkedHashMap<String, List<String>>();
        for (String k : comparison.keySet()) {
            retval.computeIfAbsent(k, key -> new ArrayList()).addAll(comparison.get(k));
        }
        return retval;
    }

    private void writeProperties(ComputingLinkedMap comparison, ConfigurationItem ci, Descriptor descriptor, int nrCi) {
        Collection nonHiddenDescriptors = descriptor.getPropertyDescriptors().stream().filter(pd -> !pd.isHidden()).collect(Collectors.toList());
        block9: for (PropertyDescriptor propertyDescriptor : nonHiddenDescriptors) {
            String key = propertyDescriptor.getName();
            Collection<String> value = propertyDescriptor.get(ci);
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: {
                    if (propertyDescriptor.isPassword()) {
                        value = PASSWORD_OBFUSCATION;
                    }
                }
                case ENUM: 
                case CI: {
                    comparison.put(key, value != null ? value.toString() : null, nrCi);
                    continue block9;
                }
                case DATE: {
                    if (value != null) {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime((Date)propertyDescriptor.get(ci));
                        comparison.put(key, DatatypeConverter.printDateTime((Calendar)cal), nrCi);
                    } else {
                        comparison.put(key, null, nrCi);
                    }
                }
                case LIST_OF_STRING: {
                    if (propertyDescriptor.isPassword()) {
                        value = Collections.singletonList(PASSWORD_OBFUSCATION);
                    }
                }
                case LIST_OF_CI: 
                case SET_OF_STRING: {
                    if (propertyDescriptor.isPassword()) {
                        value = Collections.singleton(PASSWORD_OBFUSCATION);
                    }
                }
                case SET_OF_CI: {
                    if (value instanceof AbstractStringView) {
                        this.handleCollectionOfString(comparison, key, value, nrCi);
                        continue block9;
                    }
                    List<String> valueAsStrings = ((Collection)value).stream().map(Object::toString).collect(Collectors.toList());
                    this.handleCollectionOfString(comparison, key, valueAsStrings, nrCi);
                    continue block9;
                }
                case MAP_STRING_STRING: {
                    if (propertyDescriptor.isPassword()) {
                        Set strings = ((Map)((Object)value)).keySet();
                        for (String string : strings) {
                            ((Map)((Object)value)).put(string, PASSWORD_OBFUSCATION);
                        }
                    }
                    this.handleMap(comparison, key, (Map)((Object)value), nrCi);
                    continue block9;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private void handleMap(ComputingLinkedMap comparison, String key, Map<String, String> value, int nrCi) {
        block4: {
            if (value == null) break block4;
            TreeSet<String> set = new TreeSet<String>(value.keySet());
            if (value instanceof MapStringStringView) {
                Map wrapped = ((MapStringStringView)value).getWrapped();
                for (String k : set) {
                    StringValue stringValue = (StringValue)wrapped.get(k);
                    comparison.put(key + ": " + k, stringValue.toPublicFacingValue(), nrCi);
                }
            } else {
                for (String k : set) {
                    comparison.put(key + ": " + k, value.get(k), nrCi);
                }
            }
        }
    }

    private void handleCollectionOfString(ComputingLinkedMap comparison, String key, Collection<String> value, int nrCi) {
        if (value != null) {
            List<String> list = new ArrayList<String>(value);
            if (value instanceof AbstractStringView) {
                Collection wrapped = ((AbstractStringView)value).getWrapped();
                list = wrapped.stream().map(StringValue::toPublicFacingValue).collect(Collectors.toList());
            }
            Collections.sort(list);
            comparison.put(key, String.join((CharSequence)",", list), nrCi);
        }
    }

    private void writeFields(ComputingLinkedMap comparison, ConfigurationItem entity, int nrCi) {
        comparison.put("id", entity.getId(), nrCi);
        comparison.put("type", entity.getType().toString(), nrCi);
    }

    private void checkCiTypes(Type referenceType, Iterable<ConfigurationItem> entities) {
        for (ConfigurationItem entity : entities) {
            Checks.checkArgument((boolean)entity.getType().equals((Object)referenceType), (String)"Not all configuration items are of type %s", (Object[])new Object[]{referenceType});
        }
    }

    static class ComputingLinkedMap
    extends LinkedHashMap<String, List<String>> {
        private String[] strings;

        public ComputingLinkedMap(int listSize) {
            this.strings = new String[listSize];
            Arrays.fill(this.strings, "");
        }

        @Override
        public List<String> get(Object o) {
            ArrayList<String> value = (ArrayList<String>)super.get(o);
            if (value == null) {
                value = new ArrayList<String>(Arrays.asList(this.strings));
                super.put((String)o, value);
            }
            return value;
        }

        public void put(String key, String value, int position) {
            Object values = this.get(key);
            values.remove(position);
            values.add(position, value);
        }
    }
}

