/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public final class ProxyUtils {
    private ProxyUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static <T> T getTargetObject(Object candidate) {
        try {
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised) {
                return (T)((Advised)candidate).getTargetSource().getTarget();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }
}

