/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.Bootstrapper;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerBootstrapper;
import org.springframework.cloud.config.client.RetryProperties;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ClassUtils;

public class ConfigClientRetryBootstrapper
implements Bootstrapper {
    static final boolean RETRY_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.retry.annotation.Retryable", null);

    public void intitialize(BootstrapRegistry registry) {
        if (!RETRY_IS_PRESENT) {
            return;
        }
        registry.registerIfAbsent(RetryProperties.class, context -> (RetryProperties)((Binder)context.get(Binder.class)).bind("spring.cloud.config.retry", RetryProperties.class).orElseGet(RetryProperties::new));
        registry.registerIfAbsent(RetryTemplate.class, context -> {
            RetryProperties properties = (RetryProperties)context.get(RetryProperties.class);
            return RetryTemplate.builder().maxAttempts(properties.getMaxAttempts()).exponentialBackoff(properties.getInitialInterval(), properties.getMultiplier(), properties.getMaxInterval()).build();
        });
        registry.registerIfAbsent(ConfigServerBootstrapper.LoaderInterceptor.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            boolean failFast = (Boolean)binder.bind("spring.cloud.config.fail-fast", Boolean.class).orElse((Object)false);
            if (failFast) {
                RetryTemplate retryTemplate = (RetryTemplate)context.get(RetryTemplate.class);
                return loadContext -> (ConfigData)retryTemplate.execute(retryContext -> (ConfigData)loadContext.getInvocation().apply(loadContext.getLoaderContext(), loadContext.getResource()));
            }
            return null;
        });
    }
}

