/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.util.StringRendering;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.DateTime$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.Connection;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.CustomHeader;
import akka.http.scaladsl.model.headers.Date;
import akka.http.scaladsl.model.headers.Date$;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.model.headers.Server;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding;
import akka.http.scaladsl.model.headers.User$minusAgent;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class HttpMessageRendering$ {
    public static final HttpMessageRendering$ MODULE$ = new HttpMessageRendering$();
    private static volatile Tuple2<Object, Tuple2<String, String>> cachedDateHeader = new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)new Tuple2((Object)"", (Object)""));

    private Tuple2<Object, Tuple2<String, String>> cachedDateHeader() {
        return cachedDateHeader;
    }

    private void cachedDateHeader_$eq(Tuple2<Object, Tuple2<String, String>> x$1) {
        cachedDateHeader = x$1;
    }

    private Tuple2<String, String> dateHeader() {
        block0: {
            long cachedSeconds = this.cachedDateHeader()._1$mcJ$sp();
            long now = System.currentTimeMillis();
            if (now / 1000L <= cachedSeconds) break block0;
            StringRendering r = new StringRendering();
            DateTime$.MODULE$.apply(now).renderRfc1123DateTimeString(r);
            this.cachedDateHeader_$eq((Tuple2<Object, Tuple2<String, String>>)new Tuple2((Object)BoxesRunTime.boxToLong((long)now), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Date$.MODULE$.lowercaseName()), (Object)r.get())));
        }
        return (Tuple2)this.cachedDateHeader()._2();
    }

    public void addContentHeaders(VectorBuilder<Tuple2<String, String>> headerPairs, HttpEntity entity) {
        ContentType contentType = entity.contentType();
        ContentType.Binary binary = ContentTypes$.MODULE$.NoContentType();
        Object object = (contentType == null ? binary != null : !contentType.equals(binary)) ? headerPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-type"), (Object)entity.contentType().toString())) : BoxedUnit.UNIT;
        entity.contentLengthOption().foreach((Function1 & Serializable)x$2 -> HttpMessageRendering$.$anonfun$addContentHeaders$1(headerPairs, BoxesRunTime.unboxToLong((Object)x$2)));
    }

    public Seq<Tuple2<String, String>> renderHeaders(Seq<HttpHeader> headers2, LoggingAdapter log, boolean isServer) {
        VectorBuilder headerPairs = new VectorBuilder();
        this.renderHeaders(headers2, (VectorBuilder<Tuple2<String, String>>)headerPairs, (Option<Tuple2<String, String>>)None$.MODULE$, log, isServer);
        return headerPairs.result();
    }

    public void renderHeaders(Seq<HttpHeader> headersSeq, VectorBuilder<Tuple2<String, String>> headerPairs, Option<Tuple2<String, String>> peerIdHeader, LoggingAdapter log, boolean isServer) {
        Iterator it = headersSeq.iterator();
        boolean peerIdSeen = false;
        boolean dateSeen = false;
        while (it.hasNext()) {
            RawHeader rawHeader;
            BoxedUnit boxedUnit;
            HttpHeader header = (HttpHeader)it.next();
            if ((!header.renderInResponses() || !isServer) && (!header.renderInRequests() || isServer)) continue;
            HttpHeader httpHeader = header;
            if (httpHeader instanceof Server) {
                Server server = (Server)httpHeader;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(server, headerPairs);
                    peerIdSeen = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)httpHeader;
                if (!isServer) {
                    HttpMessageRendering$.addHeader$1(user$minusAgent, headerPairs);
                    peerIdSeen = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (httpHeader instanceof Date) {
                Date date = (Date)httpHeader;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(date, headerPairs);
                    dateSeen = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)httpHeader;
                HttpMessageRendering$.addHeader$1(customHeader, headerPairs);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (httpHeader instanceof RawHeader && ((rawHeader = (RawHeader)httpHeader).is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding") || rawHeader.is("date") || rawHeader.is("server") || rawHeader.is("user-agent") || rawHeader.is("connection"))) {
                HttpMessageRendering$.suppressionWarning$1(rawHeader, "illegal RawHeader", log);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(content$minusLength, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.", log);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(content$minusType, "explicit `Content-Type` header is not allowed. Set `HttpResponse.entity.contentType` instead.", log);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(transfer$minusEncoding, "`Transfer-Encoding` header is not allowed for HTTP/2", log);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (httpHeader instanceof Connection) {
                Connection connection = (Connection)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(connection, "`Connection` header is not allowed for HTTP/2", log);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            HttpMessageRendering$.addHeader$1(httpHeader, headerPairs);
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = !dateSeen && isServer ? headerPairs.$plus$eq(this.dateHeader()) : BoxedUnit.UNIT;
        if (!peerIdSeen) {
            Option<Tuple2<String, String>> option = peerIdHeader;
            if (option instanceof Some) {
                Some some = (Some)option;
                Tuple2 peerIdTuple = (Tuple2)some.value();
                headerPairs.$plus$eq((Object)peerIdTuple);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    public static final /* synthetic */ VectorBuilder $anonfun$addContentHeaders$1(VectorBuilder headerPairs$1, long x$2) {
        return (VectorBuilder)headerPairs$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-length"), (Object)((Object)BoxesRunTime.boxToLong((long)x$2)).toString()));
    }

    private static final void suppressionWarning$1(HttpHeader h, String msg, LoggingAdapter log$1) {
        log$1.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    private static final void addHeader$1(HttpHeader h, VectorBuilder headerPairs$2) {
        headerPairs$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.lowercaseName()), (Object)h.value()));
    }

    private HttpMessageRendering$() {
    }
}

