package ai.digital.deploy.task.status.queue

import ai.digital.deploy.engine.tasker.service.TaskPathStatusService
import com.xebialabs.deployit.core.events.{TaskPathStatusDeleteEvent, TaskPathStatusEvent}
import grizzled.slf4j.Logging
import org.springframework.jms.annotation.JmsListener
import org.springframework.jms.support.converter.MessageConverter
import org.springframework.stereotype.Component

import javax.jms.TextMessage

@Component
class TaskPathStatusConsumer(taskPathStatusService: TaskPathStatusService,
                             jacksonJmsMessageConverter: MessageConverter) extends Logging {

  @JmsListener(destination = TaskPathStatusQueue.TaskPathStatusQueueELExpression, containerFactory = "xlJmsListenerContainerFactory")
  def receiveTextMessage(message: TextMessage): Unit =
    jacksonJmsMessageConverter.fromMessage(message) match {
      case taskPathStatusEvent: TaskPathStatusEvent =>
        logger.debug(
          s"Received taskPathStatusEvent ${message.getJMSMessageID} timestamp: ${message.getJMSTimestamp} taskId: ${taskPathStatusEvent.taskId} " +
            s"path: ${taskPathStatusEvent.path} status: ${taskPathStatusEvent.status}"
        )

        taskPathStatusService.createOrUpdate(taskPathStatusEvent.taskId, taskPathStatusEvent.path, taskPathStatusEvent.status, message.getJMSTimestamp)
      case taskPathStatusDeleteEvent: TaskPathStatusDeleteEvent =>
        logger.debug(
          s"Received taskPathStatusDeleteEvent ${message.getJMSMessageID} timestamp: ${message.getJMSTimestamp} taskId: ${taskPathStatusDeleteEvent.taskId}"
        )

        taskPathStatusService.delete(taskPathStatusDeleteEvent.taskId)
      case _ =>
        logger.error(s"Received unknown ${message.getJMSMessageID} timestamp: ${message.getJMSTimestamp} [$message]")
    }
}

object TaskPathStatusQueue {
  final val TaskPathStatusQueueELExpression = "#{@taskPathStatusQueueNameResolver.getTaskPathStatusQueueName()}"
}
