package ai.digital.deploy.task.config
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.core.task.SimpleAsyncTaskExecutor
import org.springframework.scheduling.annotation.EnableAsync

@Configuration
@ConditionalOnProperty(prefix = "deploy.task", name = Array("resilient"), havingValue = "true", matchIfMissing = false)
@EnableAsync(proxyTargetClass = true)
class DeploySpringAsyncConfig {
  @Bean(name = Array("simpleAsyncTaskExecutor"))
  def simpleAsyncTaskExecutor = new SimpleAsyncTaskExecutor
}

