package com.xebialabs.deployit.script

import java.util.concurrent.atomic.AtomicReference

import com.xebialabs.deployit.task.archive.TaskArchive
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.ApplicationContext
import org.springframework.stereotype.Component

@Component
class SpringBindings(@Autowired applicationContext: ApplicationContext) {
  SpringBindings.bindings.set(Map(
    "taskArchive" -> applicationContext.getBean(classOf[TaskArchive])
  ))
}

object SpringBindings {
  val bindings = new AtomicReference[Map[String, Object]](Map())
}