package com.xebialabs.deployit.core.converters

import com.xebialabs.deployit.core.api.dto.ReportLine
import com.xebialabs.deployit.core.converters.DeploymentReportLineField._
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine

import scala.jdk.CollectionConverters._
import scala.collection.mutable

object DeploymentTaskReportLineConverter {
  def toReportLine(line: DeploymentTaskReportLine): ReportLine = ReportLine.fromMap(mutable.Map(Map[String, Object](
    TASK_ID -> line.getTaskId,
    START_DATE -> line.getStartDate,
    COMPLETION_DATE -> line.getCompletionDate,
    STATUS -> line.getStatus,
    TYPE -> line.getTaskType,
    USER -> line.getUser,
    ENVIRONMENT -> line.getEnvironment,
    ENVIRONMENT_ID -> line.getEnvironmentId,
    ENVIRONMENT_ID_WITHOUT_ROOT -> line.getEnvironmentIdWithoutRoot,
    PACKAGE -> line.getDeploymentPackage,
    ROLLED_BACK -> line.getRolledBack,
    WORKER_NAME -> line.getWorkerName
  ).toSeq: _*).asJava)
}

object DeploymentReportLineField {
  val TASK_ID = "taskId"
  val START_DATE = "startDate"
  val COMPLETION_DATE = "completionDate"
  val STATUS = "status"
  val TYPE = "type"
  val USER = "user"
  val ENVIRONMENT = "environment"
  val ENVIRONMENT_ID = "environmentId"
  val ENVIRONMENT_ID_WITHOUT_ROOT = "environmentIdWithoutRoot"
  val PACKAGE = "package"
  val ROLLED_BACK = "rolledBack"
  val WORKER_NAME = "worker_name"

  val allFields = Set(TASK_ID, START_DATE, COMPLETION_DATE, STATUS, TYPE, USER, ENVIRONMENT, ENVIRONMENT_ID, ENVIRONMENT_ID_WITHOUT_ROOT, PACKAGE, ROLLED_BACK, WORKER_NAME)
}
