package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.task.archive.SuccessfulDeploymentDurationReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import org.joda.time.DateTime;

import java.util.Collection;

/*********************
 * Deployment duration over time widget
 */
public class DeploymentsDurationFrequencyWidget extends DashboardWidgetBase {

    private static final String INTERVAL = "interval";
    private static final String DEPLOYMENT_PERCENT = "deploymentPercent";
    private static final String NUM_OF_DEPLOYMENT = "numOfDeployment";

    public DeploymentsDurationFrequencyWidget(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(final DateTime beginDate, final DateTime endDate) {
        Collection<SuccessfulDeploymentDurationReportLine> searchResult = taskArchive.successfulDeploymentDurations(beginDate, endDate);
        return transformResult(searchResult);
    }

    private Report transformResult(Collection<SuccessfulDeploymentDurationReportLine> searchResult) {
        final Report report = new Report();
        searchResult.forEach( result -> {
            ReportLine line = report.addLine();
            if (result.binStart().isEmpty() && result.binEnd().isEmpty()) {
                line.addValue(INTERVAL, "All");
            } else if (result.binStart().isEmpty()) {
                line.addValue(INTERVAL, "<" + formatToMinsAndSecs((int)result.binEnd().get()));
            } else if (result.binEnd().isEmpty()) {
                line.addValue(INTERVAL, ">" + formatToMinsAndSecs((int)result.binStart().get()));
            } else {
                line.addValue(INTERVAL, formatToMinsAndSecs((int)result.binStart().get()) + " - " + formatToMinsAndSecs((int)result.binEnd().get()));
            }
            line.addValue(DEPLOYMENT_PERCENT, getFormattedPercentage(result.amount(),result.count()));
            line.addValue(NUM_OF_DEPLOYMENT, String.valueOf(result.amount()));
        });
        return report;
    }

}
