/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.AbstractTaskResource;
import com.xebialabs.deployit.core.rest.api.TaskStateView;
import com.xebialabs.deployit.core.rest.api.TaskWithStepsView;
import com.xebialabs.deployit.core.rest.api.support.TaskPermissionFilter;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class TaskResource
extends AbstractTaskResource
implements TaskService {
    public TaskState getTask(String taskId) {
        return new TaskStateView(this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, false)));
    }

    public TaskState assign(String taskId, String owner) {
        return new TaskStateView((SerializableTask)this.doAssign(taskId, owner));
    }

    public TaskState takeover(String taskId, String owner) {
        return new TaskStateView((SerializableTask)this.doTakeover(taskId, owner));
    }

    public TaskWithSteps skip(String taskId, List<Integer> stepIds) {
        return new TaskWithStepsView((SerializableTask)this.skip(taskId, stepIds, true));
    }

    public TaskWithSteps unskip(String taskId, List<Integer> stepIds) {
        return new TaskWithStepsView((SerializableTask)this.skip(taskId, stepIds, false));
    }

    public TaskWithSteps addPause(String taskId, int stepNr) {
        this.pause(taskId, stepNr);
        return new TaskWithStepsView((SerializableTask)((TaskExecutionEngine)this.engine.get()).retrieve(taskId));
    }

    public List<TaskState> getMyCurrentTasks() {
        String principal = Permissions.getAuthenticatedUserName();
        return this.getAllTasks().filter(task -> task.getOwner().equals(principal)).collect(Collectors.toList());
    }

    private Stream<TaskStateView> getAllTasks() {
        return ((TaskExecutionEngine)this.engine.get()).getAllIncompleteTasks(FetchMode.FULL).stream().map(TaskStateView::new);
    }

    public List<TaskState> getAllCurrentTasks() {
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            logger.debug("getAllCurrentTasks returning full list as ADMIN");
            return this.getAllTasks().collect(Collectors.toList());
        }
        return this.getAllTasks().filter(new TaskPermissionFilter()).collect(Collectors.toList());
    }

    public TaskWithSteps getSteps(String taskId) {
        return new TaskWithStepsView(this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, true)), this.stepLogRetriever);
    }

    public Stream<TaskState> query(LocalDate begin, LocalDate end) {
        return this.search(this.toSearchParameters(begin, end, false), false).map(TaskStateView::new);
    }

    public Stream<TaskWithSteps> export(LocalDate begin, LocalDate end) {
        return this.search(this.toSearchParameters(begin, end, false), true).map(TaskWithStepsView::new);
    }

    protected Task skip(String taskId, List<Integer> stepIds, boolean skip) {
        SerializableTask task = this.getSerializableTask(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_SKIPSTEP, task);
        if (skip) {
            ((TaskExecutionEngine)this.engine.get()).skipSteps(taskId, stepIds);
        } else {
            ((TaskExecutionEngine)this.engine.get()).unskipSteps(taskId, stepIds);
        }
        return ((TaskExecutionEngine)this.engine.get()).retrieve(taskId);
    }

    protected void pause(String taskId, int stepNr) {
        if (this.isNotCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can add pause to the task.");
        }
        ((TaskExecutionEngine)this.engine.get()).addPauseStep(taskId, Integer.valueOf(stepNr));
    }

    public StepState getStep(String taskId, int stepNr, DateTime ifModifiedSince) {
        StepState step = new TaskWithStepsView(this.viewAbleTask(this.pendingOrLiveOrArchivedTask(taskId, false)), this.stepLogRetriever).getStep(stepNr);
        if (this.hasBeenModifiedSince(step, ifModifiedSince)) {
            return step;
        }
        throw new AbstractTaskResource.NotModifiedException();
    }
}

