package com.xebialabs.deployit.core.converters

import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder
import com.xebialabs.xltype.serialization.json.JsonWriter

class ResolvedPlaceholderConverter {

  def toJson(resoledPlaceholder: ResolvedPlaceholder): String = {
    val writer = new JsonWriter
    toJson(resoledPlaceholder, writer)
    writer.toString
  }

  def toJson(resoledPlaceholder: ResolvedPlaceholder, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("encrypted").value(resoledPlaceholder.isEncrypted)
    writer.key("key").value(resoledPlaceholder.key)
    writer.key("value").value(resoledPlaceholder.value)
    writer.key("containerId").value(resoledPlaceholder.containerId)
    writer.key("containerDeleted").value(resoledPlaceholder.containerDeleted)
    writer.key("deployedAppId").value(resoledPlaceholder.deployedAppId)
    writer.key("dictionaryId").value(resoledPlaceholder.dictionaryId)
    writer.key("dictionaryDeleted").value(resoledPlaceholder.dictionaryDeleted)
    writer.key("environmentId").value(resoledPlaceholder.environmentId)
    writer.key("environmentDeleted").value(resoledPlaceholder.environmentDeleted)
    writer.key("versionId").value(resoledPlaceholder.versionId)
    writer.endObject()
  }
}
