package com.xebialabs.deployit.core.rest.api;

import java.io.IOException;
import java.util.*;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.repository.RepositoryDatabaseMetaDataService;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsAuthenticationFinder;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import com.xebialabs.license.service.LicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ServerPluginInfo;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;

@Controller
public class DeployServerResource extends ServerResource {

    private ServerConfiguration serverConfiguration;
    private RepositoryDatabaseMetaDataService databaseMetaDataService;

    public DeployServerResource(@Autowired GarbageCollectionService garbageCollectionService,
                                @Autowired LicenseService licenseService,
                                @Autowired List<ViewAsAuthenticationFinder> viewAsAuthenticationFinders,
                                @Autowired RoleService roleService,
                                @Autowired ServerConfiguration serverConfiguration,
                                @Autowired ViewAsData viewAsData,
                                @Autowired RepositoryDatabaseMetaDataService databaseMetaDataService) {
        super(garbageCollectionService, licenseService, viewAsAuthenticationFinders, roleService, serverConfiguration, viewAsData);
        this.serverConfiguration = serverConfiguration;
        this.databaseMetaDataService = databaseMetaDataService;
    }

    @Override
    public ServerInfo getInfo() {
        ClassPathResource resource = new ClassPathResource("com/xebialabs/deployit/release.properties");
        Properties release = new Properties();
        try {
            release.load(resource.getInputStream());
            ServerInfo si = new ServerInfo();
            si.setVersion(release.getProperty("version"));
            si.setServerUrl(serverConfiguration.getServerUrl());

            for (String plugin : PluginVersions.getRegisteredPlugins()) {
                si.getPluginsInfo().add(new ServerPluginInfo(plugin, PluginVersions.getVersionFor(plugin)));
            }
            si.setClasspathEntries(getServerClassPath());
            si.setDatabaseInfo(databaseMetaDataService.findMainDbImplementation());
            return si;
        } catch (IOException e) {
            throw new DeployitException(e);
        }
    }
}
