package com.xebialabs.deployit.core.rest.api

import java.lang

import com.xebialabs.deployit.core.api.XldUserProfileService
import com.xebialabs.deployit.core.api.dto.{AddUserProfile, UserProfileView}
import com.xebialabs.deployit.security.permission.PlatformPermissions.{EDIT_SECURITY, VIEW_SECURITY}
import com.xebialabs.deployit.security.service.UserProfileService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import scala.jdk.CollectionConverters._

@Controller
class XldUserProfileServiceImpl(@Autowired userProfileService: UserProfileService)
  extends AbstractUserRestrictedResource with XldUserProfileService {

  override def getUserProfile(username: String, loadCredentials: lang.Boolean): UserProfileView = {
    checkCurrentUserOrPermissions(username, VIEW_SECURITY, EDIT_SECURITY)
    val profile = userProfileService.findOne(username, loadCredentials)
    new UserProfileView(
      profile.analyticsEnabled,
      profile.credentials.map(credentials => XldUserCredentialsService.mapToUserCredentialsView(credentials)).asJava,
      profile.username
    )
  }

  override def createOrUpdateUserProfile(username: String, userProfile: AddUserProfile): Unit = {
    checkCurrentUserOrPermission(username, EDIT_SECURITY)
    userProfileService.createOrUpdate(username, userProfile.getAnalyticsEnabled)
  }
}
