package com.xebialabs.deployit.core.rest.json

import com.fasterxml.jackson.databind.{ObjectMapper, SerializationFeature}
import com.fasterxml.jackson.datatype.joda.JodaModule
import com.fasterxml.jackson.module.scala.DefaultScalaModule
import javax.ws.rs.Produces
import javax.ws.rs.core.MediaType
import javax.ws.rs.ext.{ContextResolver, Provider}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ObjectMapperContextResolver extends ContextResolver[ObjectMapper] {
  private val objectMapper = new ObjectMapper
  objectMapper.registerModule(new JodaModule)
  objectMapper.registerModule(new DefaultScalaModule)
  objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)

  override def getContext(`type`: Class[_]): ObjectMapper = objectMapper
}