package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

import static com.xebialabs.deployit.core.rest.json.PropertyDescriptorJsonWriter.writePropertyDescriptor;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class PropertyDescriptorsJsonWriter implements MessageBodyWriter<Collection<PropertyDescriptor>> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];
        }
        return PropertyDescriptor.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Collection<PropertyDescriptor> propertyDescriptors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<PropertyDescriptor> propertyDescriptors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(propertyDescriptors).getBytes());
    }

    @VisibleForTesting
    String toJson(Collection<PropertyDescriptor> propertyDescriptors) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (PropertyDescriptor descriptor : propertyDescriptors) {
            writePropertyDescriptor(writer, descriptor);
        }

        writer.endArray();
        return stringWriter.toString();
    }
}
