package com.xebialabs.deployit.core.util

import java.util

import com.xebialabs.deployit.checks.Checks.checkTrue
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{Application, Environment}
import com.xebialabs.deployit.task.TaskType
import com.xebialabs.deployit.task.TaskType.{INITIAL, ROLLBACK, UNDEPLOY, UPGRADE}

import scala.jdk.CollectionConverters._

object TaskFilterUtils {
  def buildTaskTypesFilter(taskTypes: util.List[String], onlySuccessful: Boolean): util.List[TaskType] = {
    (Option(taskTypes).map(_.asScala.toList).getOrElse(Nil) match {
      case Nil =>
        val types = List(INITIAL, UNDEPLOY, UPGRADE)
        if (!onlySuccessful) {
          ROLLBACK :: types
        } else types
      case userProvided => userProvided.map(TaskType.valueOf)
    }).asJava
  }

  def parseCiFilters(configurationItemIds: List[ConfigurationItemId]): (List[String], List[String]) = {
    configurationItemIds.foldLeft((List[String](), List[String]())) { case ((appAcc, envAcc), current) =>
      current match {
        case ci if ci.getType.instanceOf(Type.valueOf(classOf[Application])) =>
          (ci.getId :: appAcc, envAcc)
        case ci if ci.getType.instanceOf(Type.valueOf(classOf[Environment])) =>
          (appAcc, ci.getId :: envAcc)
        case _ => (appAcc, envAcc)
      }
    }
  }

  def validateTaskTypesFilter(taskTypes: util.Set[TaskType],
                              allowedTypes: util.Set[TaskType]): Unit = {
    val unsupportedValues = taskTypes.asScala.filterNot(allowedTypes.contains)
    checkTrue(
      unsupportedValues.isEmpty,
      s"Task type filter contains unsupported types: ${unsupportedValues.toList.asJava}. Allowed types are: $allowedTypes"
    )
  }
}
