/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.config.ClientProperties;
import com.xebialabs.deployit.core.config.WebSocketsProperties;
import com.xebialabs.deployit.core.rest.converters.CiIdsMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiRefsJsonWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001\u0002\b\u0010\u0001qA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!A\u0007A!A!\u0002\u0013I\u0007\"B7\u0001\t\u0003q\u0007bB?\u0001\u0005\u0004%IA \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003\u0000\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u00111\r\u0001\u0005B\u0005\u0015$\u0001H,fEN{7m[3u\u001b\u0016\u001c8/Y4f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0006\u0003!E\t!b^3cg>\u001c7.\u001a;t\u0015\t\u00112#\u0001\u0003sKN$(B\u0001\u000b\u0016\u0003\u0011\u0019wN]3\u000b\u0005Y9\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005aI\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Q\u0012aA2p[\u000e\u00011c\u0001\u0001\u001eKA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005Y\u0006twMC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"AB(cU\u0016\u001cG\u000f\u0005\u0002'g5\tqE\u0003\u0002)S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)Z\u0013AB2p]\u001aLwM\u0003\u0002-[\u000511o\\2lKRT!AL\u0018\u0002\u0007],'M\u0003\u00021c\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00013\u0003\ry'oZ\u0005\u0003i\u001d\u0012\u0001eV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3Ce>\\WM]\"p]\u001aLw-\u001e:fe\u0006\u00012-\u001b*fMNT5o\u001c8Xe&$XM\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0003sE\tAA[:p]&\u00111\b\u000f\u0002\u0011\u0007&\u0014VMZ:Kg>twK]5uKJD#!A\u001f\u0011\u0005y\"U\"A \u000b\u0005!\u0002%BA!C\u0003\u001d1\u0017m\u0019;pefT!aQ\u0018\u0002\u000b\t,\u0017M\\:\n\u0005\u0015{$!C!vi><\u0018N]3e\u00035!\u0018m]6TG\",G-\u001e7feB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jL\u0001\u000bg\u000eDW\rZ;mS:<\u0017B\u0001'J\u00055!\u0016m]6TG\",G-\u001e7fe\"\"!AT)S!\tqt*\u0003\u0002Q\u007f\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002'\u0006\u0019r/\u001a2t_\u000e\\W\r^:TG\",G-\u001e7fe\"\u0012!!P\u0001\u0010kN,'/\u00138uKJ\u001cW\r\u001d;peB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\bgV\u0004\bo\u001c:u\u0015\tYv&A\u0005nKN\u001c\u0018mZ5oO&\u0011Q\f\u0017\u0002\u0013\u0007\"\fgN\\3m\u0013:$XM]2faR|'\u000f\u000b\u0003\u0004\u001dF{\u0016%A+)\u0005\ri\u0014aF<fEN{7m[3ug\u000e{gNZ5hkJ\fG/[8o!\t\u0019W-D\u0001e\u0015\tQ3#\u0003\u0002gI\n!r+\u001a2T_\u000e\\W\r^:Qe>\u0004XM\u001d;jKND#\u0001B\u001f\u0002'\rd\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005\rT\u0017BA6e\u0005A\u0019E.[3oiB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0006{\u00051A(\u001b8jiz\"ba\\9tmf\\\bC\u00019\u0001\u001b\u0005y\u0001\"B\u001b\u0007\u0001\u00041\u0004FA9>\u0011\u00151e\u00011\u0001HQ\u0011\u0019h*\u0015*)\u0005Ml\u0004\"B+\u0007\u0001\u00041\u0006\u0006\u0002<O#~C#A^\u001f\t\u000b\u00054\u0001\u0019\u00012)\u0005el\u0004\"\u00025\u0007\u0001\u0004I\u0007FA>>\u0003=Ig\u000e];u\u0005V4g-\u001a:TSj,W#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q!!!\u0002\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005%\u00111\u0001\u0002\u0004\u0013:$\u0018\u0001E5oaV$()\u001e4gKJ\u001c\u0016N_3!\u0003Y\u0019wN\u001c4jOV\u0014X-T3tg\u0006<WM\u0011:pW\u0016\u0014H\u0003BA\t\u0003/\u0001B!!\u0001\u0002\u0014%!\u0011QCA\u0002\u0005\u0011)f.\u001b;\t\u000f\u0005e\u0011\u00021\u0001\u0002\u001c\u0005A!/Z4jgR\u0014\u0018\u0010\u0005\u0003\u0002\u001e\u0005\u0015RBAA\u0010\u0015\rQ\u0013\u0011\u0005\u0006\u0004\u0003GQ\u0016\u0001B:j[BLA!a\n\u0002 \t)R*Z:tC\u001e,'I]8lKJ\u0014VmZ5tiJL\u0018\u0001\u00055b]\u0012\u001c\b.Y6f\u0011\u0006tG\r\\3s)\t\ti\u0003\u0005\u0003\u00020\u0005]RBAA\u0019\u0015\rI\u00161\u0007\u0006\u0004\u0003kY\u0013AB:feZ,'/\u0003\u0003\u0002:\u0005E\"a\u0006#fM\u0006,H\u000e\u001e%b]\u0012\u001c\b.Y6f\u0011\u0006tG\r\\3sQ\rQ\u0011Q\b\t\u0005\u0003\u007f\t9%\u0004\u0002\u0002B)\u0019\u0001&a\u0011\u000b\u0007\u0005\u0015s&A\u0004d_:$X\r\u001f;\n\t\u0005%\u0013\u0011\t\u0002\u0005\u0005\u0016\fg.\u0001\fsK\u001eL7\u000f^3s'R|W\u000e]#oIB|\u0017N\u001c;t)\u0011\t\t\"a\u0014\t\u000f\u0005e1\u00021\u0001\u0002RA\u0019a%a\u0015\n\u0007\u0005UsEA\u000bTi>l\u0007/\u00128ea>Lg\u000e\u001e*fO&\u001cHO]=\u0002;\r|gNZ5hkJ,7\t\\5f]RLeNY8v]\u0012\u001c\u0005.\u00198oK2$B!!\u0005\u0002\\!9\u0011\u0011\u0004\u0007A\u0002\u0005u\u0003\u0003BA\u000f\u0003?JA!!\u0019\u0002 \t\u00192\t[1o]\u0016d'+Z4jgR\u0014\u0018\r^5p]\u0006Q2m\u001c8gS\u001e,(/Z'fgN\fw-Z\"p]Z,'\u000f^3sgR!\u0011qMA7!\u0011\t\t!!\u001b\n\t\u0005-\u00141\u0001\u0002\b\u0005>|G.Z1o\u0011\u001d\ty'\u0004a\u0001\u0003c\n\u0011#\\3tg\u0006<WmQ8om\u0016\u0014H/\u001a:t!\u0019\t\u0019(!\u001f\u0002~5\u0011\u0011Q\u000f\u0006\u0004\u0003o\n\u0013\u0001B;uS2LA!a\u001f\u0002v\t!A*[:u!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB5\u0006I1m\u001c8wKJ$XM]\u0005\u0005\u0003\u000f\u000b\tI\u0001\tNKN\u001c\u0018mZ3D_:4XM\u001d;fe\"\u001a\u0001!a#\u0011\u0007\u0019\ni)C\u0002\u0002\u0010\u001e\u0012A$\u00128bE2,w+\u001a2T_\u000e\\W\r^'fgN\fw-\u001a\"s_.,'\u000fK\u0002\u0001\u0003'\u0003B!a\u0010\u0002\u0016&!\u0011qSA!\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class WebSocketMessageBrokerConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiRefsJsonWriter ciRefsJsonWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    @Autowired
    @Qualifier(value="userInterceptor")
    private final ChannelInterceptor userInterceptor;
    @Autowired
    private final ClientProperties clientConfiguration;
    private final int inputBufferSize;

    public void configureWebSocketTransport(WebSocketTransportRegistration x$1) {
        super.configureWebSocketTransport(x$1);
    }

    public void configureClientOutboundChannel(ChannelRegistration x$1) {
        super.configureClientOutboundChannel(x$1);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> x$1) {
        super.addArgumentResolvers(x$1);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> x$1) {
        super.addReturnValueHandlers(x$1);
    }

    private int inputBufferSize() {
        return this.inputBufferSize;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(this.inputBufferSize());
        long idleTimeout = TimeUnit.MINUTES.toMillis(this.clientConfiguration.getSession().getTimeoutMinute());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public void configureClientInboundChannel(ChannelRegistration registry) {
        registry.interceptors(new ChannelInterceptor[]{this.userInterceptor});
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiIdsMessageConverter(this.ciRefsJsonWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiRefsJsonWriter ciRefsJsonWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler, @Autowired @Qualifier(value="userInterceptor") ChannelInterceptor userInterceptor, @Autowired WebSocketsProperties webSocketsConfiguration, @Autowired ClientProperties clientConfiguration) {
        this.ciRefsJsonWriter = ciRefsJsonWriter;
        this.taskScheduler = taskScheduler;
        this.userInterceptor = userInterceptor;
        this.clientConfiguration = clientConfiguration;
        this.inputBufferSize = webSocketsConfiguration.messageBroker().inputBufferSize();
    }
}

