package com.xebialabs.deployit.core.converters

import com.xebialabs.deployit.core.api.dto.UserSessionsOverview
import com.xebialabs.xltype.serialization.json.JsonWriter

class SessionOverviewConverter {

  def toJson(sessionOverview: UserSessionsOverview): String = {
    val writer = new JsonWriter
    toJson(sessionOverview, writer)
    writer.toString
  }

  def toJson(sessionOverview: UserSessionsOverview, writer: JsonWriter): Unit = {
    writer.`object`()
    writer.key("totalActiveUsers").value(sessionOverview.getTotalActiveUsers)
    writer.key("totalControlTasks").value(sessionOverview.getTotalControlTasks)
    writer.key("totalDeploymentTasks").value(sessionOverview.getTotalDeploymentTasks)
    writer.endObject()
  }
}
