package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.archive.TaskArchive;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DeploymentsStateBreakdownReport {

    private final TaskArchive taskArchive;

    public DeploymentsStateBreakdownReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(final FilterType filterType, final List<ConfigurationItemId> filterCriteria) {
        return generateReportData(fetchReportData(filterType, filterCriteria));
    }

    private Map<String,Integer> fetchReportData(final FilterType filterType, final List<ConfigurationItemId> filterCriteria) {
        switch (filterType) {
            case APPLICATION:
                return taskArchive.countSuccessfulDeploymentsOfApplications(getIds(filterCriteria));
            case ENVIRONMENT:
                return taskArchive.countSuccessfulDeploymentsOnEnvironments(getIds(filterCriteria));
            default:
                throw new UnsupportedOperationException("Report filter type, " + filterType + " is not supported");
        }
    }

    private static List<String> getIds(final List<ConfigurationItemId> filterCriteria) {
        return filterCriteria.stream().map(ConfigurationItemId::getId).collect(Collectors.toList());
    }

    private static Report generateReportData(Map<String, Integer> tasks) {
        return Report.fromLines(tasks.entrySet().stream().map(e -> generateReportLine(e.getKey(), e.getValue())));
    }

    private static ReportLine generateReportLine(String entity, Integer count) {
        final ReportLine reportLine = new ReportLine();
        reportLine.addValue("entityName", entity);
        reportLine.addValue("Id", entity);
        reportLine.addValue("IdWithoutRoot", entity.substring(entity.indexOf('/') + 1));
        reportLine.addValue("noOfSuccessfulDeployments", count.toString());
        return reportLine;
    }

}
