package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util

import com.xebialabs.deployit.core.api.dto.DefinedPlaceholderReference
import com.xebialabs.xltype.serialization.json.JsonWriter
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import javax.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class DefinedPlaceholderReferenceJsonWriter extends MessageBodyWriter[util.Collection[DefinedPlaceholderReference]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[DefinedPlaceholderReference].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(viewList: util.Collection[DefinedPlaceholderReference], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(viewList: util.Collection[DefinedPlaceholderReference], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val streamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(viewList, new JsonWriter(streamWriter))
    streamWriter.flush()
  }

  private def writeJson(viewList: util.Collection[DefinedPlaceholderReference], writer: JsonWriter): Unit = {
    writer.array
    viewList.forEach(view => {
      writer.`object`()
      writer.key("id").value(view.getId)
      writer.key("ciType").value(view.getCiType)
      writer.key("securedCiId").value(view.getSecuredCiId)
      writer.endObject()
    })
    writer.endArray
  }
}
