/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.service.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ControlTaskResource
extends AbstractSecuredResource
implements ControlService {
    @Autowired
    private ControlTaskService controlTaskService;
    @Autowired
    private Validator validator;

    public Control prepare(String controlName, String id) {
        this.checkPermission(DeployitPermissions.CONTROLTASK_EXECUTE, id);
        return this.controlTaskService.prepare(controlName, id);
    }

    @Workdir(prefix="task", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    public String createTask(Control control) {
        this.checkPermission(DeployitPermissions.CONTROLTASK_EXECUTE, control.getConfigurationItem().getId());
        this.validate(control);
        return this.controlTaskService.create(control, Permissions.getAuthentication(), WorkdirHolder.get());
    }

    private void validate(Control control) {
        if (control.getParameters() != null) {
            this.validator.validateCi((ConfigurationItem)control.getParameters());
        }
    }
}

