package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.task.TaskType;
import org.joda.time.DateTime;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import static com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks.*;

public class TaskStateData {

    private AtomicInteger noOfSuccessfulDeployments = new AtomicInteger(0);
    private AtomicInteger noOfFailedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfAbortedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfRollbacks = new AtomicInteger(0);

    private Long averageDeploymentTime = 0L;

    public AtomicInteger getNoOfSuccessfulDeployments() {
        return noOfSuccessfulDeployments;
    }

    public void setNoOfSuccessfulDeployments(AtomicInteger noOfSuccessfulDeployments) {
        this.noOfSuccessfulDeployments = noOfSuccessfulDeployments;
    }

    public AtomicInteger getNoOfFailedDeployments() {
        return noOfFailedDeployments;
    }

    public void setNoOfFailedDeployments(AtomicInteger noOfFailedDeployments) {
        this.noOfFailedDeployments = noOfFailedDeployments;
    }

    public AtomicInteger getNoOfAbortedDeployments() {
        return noOfAbortedDeployments;
    }

    public void setNoOfAbortedDeployments(AtomicInteger noOfAbortedDeployments) {
        this.noOfAbortedDeployments = noOfAbortedDeployments;
    }

    public AtomicInteger getNoOfRollbacks() {
        return noOfRollbacks;
    }

    public Long getAverageDeploymentTime() {
        return averageDeploymentTime;
    }

    public void setAverageDeploymentTime(Long averageDeploymentTime) {
        this.averageDeploymentTime = averageDeploymentTime;
    }

    /*
     * Derived counters
     */

    public int getTotalSuccessfulTasks() {
        return noOfFailedDeployments.get() + noOfSuccessfulDeployments.get();
    }

    public int getTotalTasks() {
        return noOfAbortedDeployments.get() + noOfFailedDeployments.get() + noOfSuccessfulDeployments.get() + noOfRollbacks.get();
    }

    public void addTask(Map<String, Object> task) {
        if (TaskType.ROLLBACK.name().equals(task.get(task_type().name()))) {
            noOfRollbacks.incrementAndGet();
            return;
        }

        if (task.get(status().name()).equals(TaskExecutionState.DONE.toString())) {
            if (task.containsKey(failure_count().name()) && ((Number) task.get(failure_count().name())).intValue() > 0) {
                noOfFailedDeployments.incrementAndGet();
            } else {
                noOfSuccessfulDeployments.incrementAndGet();
            }
        } else if (task.get(status().name()).equals(TaskExecutionState.CANCELLED.toString())) {
            noOfAbortedDeployments.incrementAndGet();
        }
    }

    public void addTaskAndDuration(Map<String, Object> task) {
        addTask(task);
        if (task.get(status().name()).equals(TaskExecutionState.DONE.toString())) {
            averageDeploymentTime += (((DateTime) task.get(end_date().name())).getMillis() - ((DateTime) task.get(start_date().name())).getMillis());
        }
    }
}
