/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.http.enricher.PaginationService;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.AuditPreviewRow;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.report.AppEnvStatusReport;
import com.xebialabs.deployit.engine.api.dto.report.DeploymentsStatusOverview;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\r5g\u0001\u0002\u000f\u001e\u0001)B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!I\u0007A!A!\u0002\u0013Q\u0007\"\u00028\u0001\t\u0003y\u0007\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0011-\tI\u0001\u0001a\u0001\u0002\u0004%I!a\u0003\t\u0015\u0005u\u0001\u00011A\u0001B\u0003&\u0001\u0010C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u00119\u0005\u0001C!\u0005\u0013BqA!)\u0001\t\u0013\u0011\u0019\u000bC\u0004\u0003P\u0002!\tE!5\t\u000f\t%\b\u0001\"\u0011\u0003l\"911\u0001\u0001\u0005\n\r\u0015\u0001bBB#\u0001\u0011%1q\t\u0005\b\u0007+\u0002A\u0011IB,\u0011\u001d\u0019I\u0006\u0001C!\u0007/Bqaa\u0017\u0001\t\u0003\u001ai\u0006C\u0004\u0004\\\u0001!\tea\u0019\t\u000f\r5\u0004\u0001\"\u0011\u0004p!91q\u0011\u0001\u0005B\r%\u0005bBBN\u0001\u0011\u00053Q\u0014\u0002\u0012%\u0016\u0004xN\u001d;TKJ4\u0018nY3J[Bd'B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0003A\u0005\nAA]3ti*\u0011!eI\u0001\u0005G>\u0014XM\u0003\u0002%K\u0005AA-\u001a9m_fLGO\u0003\u0002'O\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002Q\u0005\u00191m\\7\u0004\u0001M!\u0001aK\u00199!\tas&D\u0001.\u0015\tqs$A\u0004tK\u000e,(/\u001a3\n\u0005Aj#aF!cgR\u0014\u0018m\u0019;TK\u000e,(/\u001a3SKN|WO]2f!\t\u0011d'D\u00014\u0015\tqBG\u0003\u00026G\u00051QM\\4j]\u0016L!aN\u001a\u0003\u001bI+\u0007o\u001c:u'\u0016\u0014h/[2f!\tId(D\u0001;\u0015\tYD(A\u0003tY\u001a$$NC\u0001>\u0003!9'/\u001b>{Y\u0016$\u0017BA ;\u0005\u001daunZ4j]\u001e\fqB]3q_J$x)\u001a8fe\u0006$xN\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0006\nqa]3sm&\u001cW-\u0003\u0002G\u0007\ny!+\u001a9peR<UM\\3sCR|'/A\tqC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"!\u0013,\u000e\u0003)S!a\u0013'\u0002\u0011\u0015t'/[2iKJT!!\u0014(\u0002\t!$H\u000f\u001d\u0006\u0003\u001fB\u000b1a]9m\u0015\t\t&+\u0001\u0004eKBdw.\u001f\u0006\u0003'R\u000bq\u0001Z5hSR\fGNC\u0001V\u0003\t\t\u0017.\u0003\u0002X\u0015\n\t\u0002+Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002\u0019\rL'+\u001a9pg&$xN]=\u0011\u0005isV\"A.\u000b\u0005=c&BA/$\u0003)\u0011X\r]8tSR|'/_\u0005\u0003?n\u0013AbQ5SKB|7/\u001b;pef\f1\u0002^1tW\u0006\u00138\r[5wKB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\bCJ\u001c\u0007.\u001b<f\u0015\t17%\u0001\u0003uCN\\\u0017B\u00015d\u0005-!\u0016m]6Be\u000eD\u0017N^3\u0002!\u0011|wO\u001c7pC\u0012\u0014Vm]8ve\u000e,\u0007CA6m\u001b\u0005i\u0012BA7\u001e\u0005A!un\u001e8m_\u0006$'+Z:pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0007aF\u00148\u000f^;\u0011\u0005-\u0004\u0001\"\u0002!\u0007\u0001\u0004\t\u0005\"B$\u0007\u0001\u0004A\u0005\"\u0002-\u0007\u0001\u0004I\u0006\"\u00021\u0007\u0001\u0004\t\u0007\"B5\u0007\u0001\u0004Q\u0017\u0001\u0003:fgB|gn]3\u0016\u0003a\u00042!_A\u0003\u001b\u0005Q(BA>}\u0003\r\u0019\b/\u001b\u0006\u0003{z\f\u0001B]3ti\u0016\f7/\u001f\u0006\u0004\u007f\u0006\u0005\u0011!\u00026c_N\u001c(BAA\u0002\u0003\ry'oZ\u0005\u0004\u0003\u000fQ(\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017\u0001\u0004:fgB|gn]3`I\u0015\fH\u0003BA\u0007\u00033\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0003\u0003'\tQa]2bY\u0006LA!a\u0006\u0002\u0012\t!QK\\5u\u0011!\tY\u0002CA\u0001\u0002\u0004A\u0018a\u0001=%c\u0005I!/Z:q_:\u001cX\r\t\u0015\u0004\u0013\u0005\u0005\u0002\u0003BA\u0012\u0003gi!!!\n\u000b\u0007\t\n9C\u0003\u0003\u0002*\u0005-\u0012A\u0001:t\u0015\u0011\ti#a\f\u0002\u0005]\u001c(BAA\u0019\u0003\u0015Q\u0017M^1y\u0013\u0011\t)$!\n\u0003\u000f\r{g\u000e^3yi\u0006Y1/\u001a;SKN\u0004xN\\:f)\u0011\ti!a\u000f\t\u000bYT\u0001\u0019\u0001=\u0002\u0019M,GoQ5GS2$XM]:\u0015\r\u00055\u0011\u0011IA'\u0011\u001d\t\u0019e\u0003a\u0001\u0003\u000b\n\u0001c]3be\u000eD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002K&\u0019\u00111J3\u00039\u0005\u00138\r[5wK\u0012$\u0016m]6TK\u0006\u00148\r\u001b)be\u0006lW\r^3sg\"9\u0011qJ\u0006A\u0002\u0005E\u0013\u0001F2p]\u001aLw-\u001e:bi&|g.\u0013;f[&#7\u000f\u0005\u0004\u0002T\u0005u\u0013\u0011M\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!Q\u000f^5m\u0015\t\tY&\u0001\u0003kCZ\f\u0017\u0002BA0\u0003+\u0012A\u0001T5tiB!\u00111MA5\u001b\t\t)GC\u0002\u0002hM\n1\u0001\u001a;p\u0013\u0011\tY'!\u001a\u0003'\r{gNZ5hkJ\fG/[8o\u0013R,W.\u00133\u0002\u0019M$(/Z1n%\u0016\u0004xN\u001d;\u0016\t\u0005E\u00141\u0011\u000b\t\u0003g\n)*!*\u00020B1\u0011QOA>\u0003\u007fj!!a\u001e\u000b\t\u0005e\u0014QK\u0001\u0007gR\u0014X-Y7\n\t\u0005u\u0014q\u000f\u0002\u0007'R\u0014X-Y7\u0011\t\u0005\u0005\u00151\u0011\u0007\u0001\t\u001d\t)\t\u0004b\u0001\u0003\u000f\u0013\u0011\u0001V\t\u0005\u0003\u0013\u000by\t\u0005\u0003\u0002\u0010\u0005-\u0015\u0002BAG\u0003#\u0011qAT8uQ&tw\r\u0005\u0003\u0002\u0010\u0005E\u0015\u0002BAJ\u0003#\u00111!\u00118z\u0011\u001d\t9\n\u0004a\u0001\u00033\u000b1\u0002]1hS:<W*Y=cKB1\u0011qBAN\u0003?KA!!(\u0002\u0012\t1q\n\u001d;j_:\u0004B!a\u0019\u0002\"&!\u00111UA3\u0005\u0019\u0001\u0016mZ5oO\"9\u0011q\u0015\u0007A\u0002\u0005%\u0016a\u00032vS2$\u0007+\u0019:b[N\u0004\u0002\"a\u0004\u0002,\u0006}\u0015QI\u0005\u0005\u0003[\u000b\tBA\u0005Gk:\u001cG/[8oc!9\u0011\u0011\u0010\u0007A\u0002\u0005E\u0006\u0003CA\b\u0003W\u000b)%a\u001d\u00025M$(/Z1n\t\u0016\u0004Hn\\=nK:$H+Y:l%\u0016\u0004xN\u001d;\u00155\u0005]\u0016qXAh\u0003'\f9.a9\u0002\u0000\n\r!q\u0001B\f\u00057\u0011)C!\u000b\u0011\r\u0005U\u00141PA]!\u0011\t\u0019'a/\n\t\u0005u\u0016Q\r\u0002\u0019\t\u0016\u0004Hn\\=nK:$H+Y:l%\u0016\u0004xN\u001d;MS:,\u0007bBAa\u001b\u0001\u0007\u00111Y\u0001\u0006E\u0016<\u0017N\u001c\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019Q0!3\u000b\u0005y\t\u0013\u0002BAg\u0003\u000f\u0014A\u0001R1uK\"9\u0011\u0011[\u0007A\u0002\u0005\r\u0017aA3oI\"9\u0011Q[\u0007A\u0002\u0005e\u0015A\u00029bO&tw\rC\u0004\u0002Z6\u0001\r!a7\u0002\u000b=\u0014H-\u001a:\u0011\r\u0005M\u0013QLAo!\u0011\t\u0019'a8\n\t\u0005\u0005\u0018Q\r\u0002\t\u001fJ$WM]5oO\"9\u0011Q]\u0007A\u0002\u0005\u001d\u0018!B;tKJ\u001c\bCBA*\u0003;\nI\u000f\u0005\u0003\u0002l\u0006eh\u0002BAw\u0003k\u0004B!a<\u0002\u00125\u0011\u0011\u0011\u001f\u0006\u0004\u0003gL\u0013A\u0002\u001fs_>$h(\u0003\u0003\u0002x\u0006E\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002|\u0006u(AB*ue&twM\u0003\u0003\u0002x\u0006E\u0001b\u0002B\u0001\u001b\u0001\u0007\u0011q]\u0001\u000bi\u0006\u001c8n\u0015;bi\u0016\u001c\bb\u0002B\u0003\u001b\u0001\u0007\u0011q]\u0001\ni\u0006\u001c8\u000eV=qKNDqA!\u0003\u000e\u0001\u0004\u0011Y!A\u0005gKR\u001c\u0007.T8eKB!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u0012M\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\tU!q\u0002\u0002\n\r\u0016$8\r['pI\u0016DqA!\u0007\u000e\u0001\u0004\tI/\u0001\u0004uCN\\\u0017\n\u001a\u0005\b\u0005;i\u0001\u0019\u0001B\u0010\u00039yg\u000e\\=Tk\u000e\u001cWm]:gk2\u0004B!a\u0004\u0003\"%!!1EA\t\u0005\u001d\u0011un\u001c7fC:DqAa\n\u000e\u0001\u0004\tI/\u0001\u0006x_J\\WM\u001d(b[\u0016Dq!a\u0014\u000e\u0001\u0004\t\t&A\u0007hKR$\u0016m]6SKB|'\u000f\u001e\u000b\u001b\u0003o\u0013yC!\r\u00034\tU\"q\u0007B\u001d\u0005w\u0011iDa\u0010\u0003B\t\r#Q\t\u0005\b\u0003\u0003t\u0001\u0019AAb\u0011\u001d\t\tN\u0004a\u0001\u0003\u0007Dq!!6\u000f\u0001\u0004\ty\nC\u0004\u0002Z:\u0001\r!a7\t\u000f\u0005\u0015h\u00021\u0001\u0002h\"9!\u0011\u0001\bA\u0002\u0005\u001d\bb\u0002B\u0003\u001d\u0001\u0007\u0011q\u001d\u0005\b\u0005\u0013q\u0001\u0019\u0001B\u0006\u0011\u001d\u0011IB\u0004a\u0001\u0003SDqA!\b\u000f\u0001\u0004\u0011y\u0002C\u0004\u0003(9\u0001\r!!;\t\u000f\u0005=c\u00021\u0001\u0002R\u0005\u0011Bm\\<oY>\fG\rV1tWJ+\u0007o\u001c:u)Y\tIOa\u0013\u0003N\t=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\\tu\u0003bBAa\u001f\u0001\u0007\u00111\u0019\u0005\b\u0003#|\u0001\u0019AAb\u0011\u001d\tIn\u0004a\u0001\u00037Dq!!:\u0010\u0001\u0004\t9\u000fC\u0004\u0003\u0002=\u0001\r!a:\t\u000f\t\u0015q\u00021\u0001\u0002h\"9!\u0011D\bA\u0002\u0005%\bb\u0002B\u000f\u001f\u0001\u0007!q\u0004\u0005\b\u0005Oy\u0001\u0019AAu\u0011\u001d\tye\u0004a\u0001\u0003#B3b\u0004B1\u0005k\u00129Ha\u001f\u0003~A!!1\rB9\u001b\t\u0011)G\u0003\u0003\u0003h\t%\u0014AC1o]>$\u0018\r^5p]*!!1\u000eB7\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\t\t=\u0014\u0011A\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!!1\u000fB3\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006)a/\u00197vK\u0006\u0012!\u0011P\u0001\u001ce\u0016\u0004xN\u001d;j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002\u0011I,\u0017\rZ(oYfL\u0012!\u0001\u0015\f\u001f\t\u0005%1\u0012BG\u0005#\u0013\u0019\n\u0005\u0003\u0003\u0004\n\u001dUB\u0001BC\u0015\tix$\u0003\u0003\u0003\n\n\u0015%aB,pe.$\u0017N]\u0001\u0007aJ,g-\u001b=\"\u0005\t=\u0015\u0001\u00033po:dw.\u00193\u0002\u000b\rdW-\u00198%\u0005\tU\u0015\u0002\u0002BL\u00053\u000ba!\u0011'X\u0003f\u001b&\u0002\u0002BN\u0005;\u000bQa\u00117fC:TAAa(\u0003\u0006\u00069qk\u001c:lI&\u0014\u0018aF:ue\u0016\fWnQ8oiJ|G\u000eV1tWJ+\u0007o\u001c:u)a\u0011)K!,\u00030\nE&Q\u0017B]\u0005w\u0013iLa0\u0003B\n\r'Q\u0019\t\u0007\u0003k\nYHa*\u0011\t\u0005\r$\u0011V\u0005\u0005\u0005W\u000b)GA\u000bD_:$(o\u001c7UCN\\'+\u001a9peRd\u0015N\\3\t\u000f\u0005\u0005\u0007\u00031\u0001\u0002D\"9\u0011\u0011\u001b\tA\u0002\u0005\r\u0007b\u0002BZ!\u0001\u0007\u0011q]\u0001\u0007gR\fG/Z:\t\u000f\t]\u0006\u00031\u0001\u0002j\u0006AA/Y:l\u001d\u0006lW\rC\u0004\u0003\nA\u0001\rAa\u0003\t\u000f\u0005\u0015\b\u00031\u0001\u0002h\"9\u0011\u0011\u001c\tA\u0002\u0005m\u0007b\u0002B\u0014!\u0001\u0007\u0011\u0011\u001e\u0005\b\u00053\u0001\u0002\u0019AAu\u0011\u001d\t)\u000e\u0005a\u0001\u00033CqAa2\u0011\u0001\u0004\u0011I-A\u0004uCJ<W\r^:\u0011\r\u0005M#1ZAu\u0013\u0011\u0011i-!\u0016\u0003\u0007M+G/A\u000bhKR\u001cuN\u001c;s_2$\u0016m]6t%\u0016\u0004xN\u001d;\u00151\t\u0015&1\u001bBk\u0005/\u0014INa7\u0003^\n}'\u0011\u001dBr\u0005K\u00149\u000fC\u0004\u0002BF\u0001\r!a1\t\u000f\u0005E\u0017\u00031\u0001\u0002D\"9!1W\tA\u0002\u0005\u001d\bb\u0002B\\#\u0001\u0007\u0011\u0011\u001e\u0005\b\u0005\u0013\t\u0002\u0019\u0001B\u0006\u0011\u001d\t)/\u0005a\u0001\u0003ODq!!7\u0012\u0001\u0004\tY\u000eC\u0004\u0003(E\u0001\r!!;\t\u000f\te\u0011\u00031\u0001\u0002j\"9\u0011Q[\tA\u0002\u0005}\u0005b\u0002Bd#\u0001\u0007!\u0011Z\u0001\u001bI><h\u000e\\8bI\u000e{g\u000e\u001e:pYR\u000b7o[:SKB|'\u000f\u001e\u000b\u0015\u0003S\u0014iOa<\u0003r\nM(Q\u001fB|\u0005s\u0014YP!@\t\u000f\u0005\u0005'\u00031\u0001\u0002D\"9\u0011\u0011\u001b\nA\u0002\u0005\r\u0007b\u0002BZ%\u0001\u0007\u0011q\u001d\u0005\b\u0005o\u0013\u0002\u0019AAu\u0011\u001d\t)O\u0005a\u0001\u0003ODq!!7\u0013\u0001\u0004\tY\u000eC\u0004\u0003(I\u0001\r!!;\t\u000f\te!\u00031\u0001\u0002j\"9!q\u0019\nA\u0002\t%\u0007f\u0003\n\u0003b\tU$q\u000fB>\u0005{B3B\u0005BA\u0005\u0017\u0013iI!%\u0003\u0014\u00069B.[:u\u00032d7)[:PMRK\b/Z$s_V\u0004X\r\u001a\u000b\u0007\u0007\u000f\u0019\u0019c!\u000f\u0011\u0011\r%11CB\f\u0003Sl!aa\u0003\u000b\t\r51qB\u0001\nS6lW\u000f^1cY\u0016TAa!\u0005\u0002\u0012\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rU11\u0002\u0002\u0004\u001b\u0006\u0004\b\u0003BB\r\u0007?i!aa\u0007\u000b\t\ru\u0011\u0011L\u0001\u0005Y\u0006tw-\u0003\u0003\u0004\"\rm!aB%oi\u0016<WM\u001d\u0005\b\u0007K\u0019\u0002\u0019AB\u0014\u0003\u0019\u0019\u0017\u000eV=qKB!1\u0011FB\u001b\u001b\t\u0019YC\u0003\u0003\u0004.\r=\u0012a\u0002:fM2,7\r\u001e\u0006\u0004=\rE\"bAB\u001aG\u00051\u0001\u000f\\;hS:LAaa\u000e\u0004,\t!A+\u001f9f\u0011\u001d\u0019Yd\u0005a\u0001\u0007{\t\u0001bZ3u\u0019\u0006\u0014W\r\u001c\t\t\u0003\u001f\tYka\u0010\u0002jB\u0019!l!\u0011\n\u0007\r\r3LA\u0012D_:4\u0017nZ;sCRLwN\\%uK6$\u0015\r^1XSRD\u0017J\u001c;fe:\fG.\u00133\u0002\u001b1L7\u000f\u001e+za\u0016\u0004\u0016\r\u001e5t)!\t\tf!\u0013\u0004R\rM\u0003bBB&)\u0001\u00071QJ\u0001\fCJ\u001c\u0007.\u001b<fI\u000eK7\u000f\u0005\u0005\u0002l\u000e=3qCAt\u0013\u0011\u0019)\"!@\t\u000f\rmB\u00031\u0001\u0004>!91Q\u0005\u000bA\u0002\r\u001d\u0012\u0001\u00057jgR,eN^5s_:lWM\u001c;t)\t\t\t&\u0001\tmSN$\u0018\t\u001d9mS\u000e\fG/[8og\u0006\u0019Bm\\<oY>\fG-Q;eSR\u0014V\r]8siR\u0011\u0011\u0011\u001e\u0015\f/\t\u0005$Q\u000fB<\u0005w\u0012i\bK\u0006\u0018\u0005\u0003\u0013YI!$\u0003\u0012\nME\u0003BAu\u0007KBqaa\u001a\u0019\u0001\u0004\t9/A\u0004g_2$WM]:)\u0017a\u0011\tG!\u001e\u0003x\tm$Q\u0010\u0015\f1\t\u0005%1\u0012BG\u0005#\u0013\u0019*\u0001\nqe\u00164\u0018.Z<Bk\u0012LGOU3q_J$H\u0003CB9\u0007s\u001aYh! \u0011\r\u0005U\u00141PB:!\u0011\t\u0019g!\u001e\n\t\r]\u0014Q\r\u0002\u0010\u0003V$\u0017\u000e\u001e)sKZLWm\u001e*po\"91qM\rA\u0002\u0005\u001d\bbBAm3\u0001\u0007\u00111\u001c\u0005\b\u0003+L\u0002\u0019AAPQ-I\"\u0011\rB;\u0005o\u0012YH! )\u000fe\u0011\tIa#\u0004\u0004\u0006\u00121QQ\u0001\baJ,g/[3x\u0003E9W\r^*uCR,8o\u0014<feZLWm\u001e\u000b\u0007\u0007\u0017\u001b9j!'\u0011\t\r551S\u0007\u0003\u0007\u001fSAa!%\u0002f\u00051!/\u001a9peRLAa!&\u0004\u0010\nIB)\u001a9m_flWM\u001c;t'R\fG/^:Pm\u0016\u0014h/[3x\u0011\u001d\t\tM\u0007a\u0001\u0003\u0007Dq!!5\u001b\u0001\u0004\t\u0019-A\bhKR\f\u0005\u000f]#omN#\u0018\r^;t)\u0019\u0019yja*\u0004*B1\u00111KA/\u0007C\u0003Ba!$\u0004$&!1QUBH\u0005I\t\u0005\u000f]#omN#\u0018\r^;t%\u0016\u0004xN\u001d;\t\u000f\u0005\u00057\u00041\u0001\u0002D\"9\u0011\u0011[\u000eA\u0002\u0005\r\u0007f\u0001\u0001\u0004.B!1qVB^\u001b\t\u0019\tL\u0003\u0003\u0003h\rM&\u0002BB[\u0007o\u000bqAZ1di>\u0014\u0018P\u0003\u0003\u0004:\n5\u0014!\u00022fC:\u001c\u0018\u0002BB_\u0007c\u0013\u0011\"Q;u_^L'/\u001a3)\u0007\u0001\u0019\t\r\u0005\u0003\u0004D\u000e%WBABc\u0015\u0011\u00199M!\u001c\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0004L\u000e\u0015'AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(configurationItemIds).asScala()).toList().flatten(Predef$.MODULE$.$conforms())));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> pagingMaybe, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limitedMaybe = pagingMaybe.map((Function1 & Serializable)paging -> new Tuple2(paging, (Object)$this.paginationService.getLimitedPaging(paging)));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limitedMaybe.map((Function1 & Serializable)x$3 -> (Paging)x$3._2()).getOrElse((Function0 & Serializable)() -> new Paging()));
        limitedMaybe.foreach((Function1 & Serializable)limitedPaging -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)limitedPaging._1(), (Paging)limitedPaging._2(), this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Nil()).asJava(), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Option<Paging> paging, java.util.Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            params.withUniqueId(taskId);
            Object object = users != null && !users.isEmpty() ? params.forUsers((java.util.Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Paging paging, java.util.Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, taskId, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, java.util.Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, taskId, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(ControlTaskReportLineField$.MODULE$.allFields()).asJava(), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.listInternal(params)).asScala().map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((Set)cisInRepository.keySet());
        List onlyInArchive = ((IterableOnceOps)archivedCis.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)CollectionConverters$.MODULE$.ListHasAsScala(paths).asScala().filter((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : package$.MODULE$.Nil();
            return nil$;
        })).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((IterableOnceOps)archivedCis.view().filterKeys((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatMap((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala())).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)((StrictOptimizedSeqOps)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$5 -> new ConfigurationItemId(x$5, ciType))).asJava();
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getEnvironments()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getApplications()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(Collections.emptyList(), this.downloadResource);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport(java.util.List<String> folders) {
        return this.reportGenerator.generateAuditReport(folders, this.downloadResource);
    }

    @Workdir(prefix="preview")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Stream<AuditPreviewRow> previewAuditReport(java.util.List<String> folders, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging) {
        AuditPreviewReport previewReport = this.reportGenerator.previewAuditReport(folders, order, paging);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> previewReport.total());
        return previewReport.currentPageData().stream();
    }

    public DeploymentsStatusOverview getStatusOverview(Date begin, Date end) {
        return this.reportGenerator.buildStatusOverview(begin, end);
    }

    public java.util.List<AppEnvStatusReport> getAppEnvStatus(Date begin, Date end) {
        return this.reportGenerator.buildAppEnvStatusReport(begin, end);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

